﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ProgramowanieObiektowe
{
    class Program
    {
        static void TestSzablonKlasy()
        {
            Klasa obiektKlasy; //tu tylko deklaruję referencję
            obiektKlasy = new Klasa(1); //tu powstaje instancja
            obiektKlasy.ZerujPole();
            //obiekt.pole = 2;
            obiektKlasy.Własność = 2;
            Console.WriteLine(obiektKlasy.ToString());
            Console.WriteLine(obiektKlasy.Własność.ToString());

            Console.WriteLine();

            Struktura obiektStruktury = new Struktura(1); //tu powstaje instancja            
            obiektStruktury.ZerujPole();
            //obiektStruktury.pole = 2;
            obiektStruktury.Własność = 2;
            Console.WriteLine(obiektStruktury.ToString());
            Console.WriteLine(obiektStruktury.Własność.ToString());
        }

        static void TestKlasyVsStruktury()
        {
            //typ referencyjny
            Klasa referencja1 = new Klasa(2);
            Klasa referencja2 = referencja1; //kopiowanie referencji
            referencja1.Własność = 3;
            Console.WriteLine("Klasy: " + referencja1.ToString() + " - " + referencja2.ToString());

            //typ wartościowy            
            Struktura obiekt1 = new Struktura(2);
            Struktura obiekt2 = obiekt1; //klonowanie
            obiekt1.Własność = 3;
            Console.WriteLine("Struktury: " + obiekt1.ToString() + " - " + obiekt2.ToString());
        }

        static void TestKot()
        {
            Kot mruczek = new Kot(false);
            Console.WriteLine(mruczek.ToString());
            mruczek.Miauczy("Miauuu (początek)");
            if (mruczek.PełnyBrzuch) mruczek.IdźNaSpacer();
            else
            {
                mruczek.Jedz();
                //mruczek.IdźNaSpacer();
            }
            mruczek.Miauczy("Miauuu (koniec)");
        }

        static void TestSamochód()
        {
            Samochód samochód = new Samochód();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 1;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 0;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WyłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
        }

        static void TestUłamek()
        {
            try
            {
                Ułamek u = new Ułamek();
                u.Licznik = 1;
                u.Mianownik = 2;
                Console.WriteLine("Ułamek: " + u);
                Console.WriteLine("Suma: " + (u + u).ToString());
                Console.WriteLine("Różnica: " + (u - u).ToString());
                Console.WriteLine("Iloczyn: " + (u * u).ToString());
                Console.WriteLine("Iloraz: " + (u / u).ToString());

                Console.WriteLine();

                Ułamek u1 = new Ułamek(1, 2);
                Ułamek u2 = new Ułamek(2, 3);
                Console.WriteLine("Suma: " + (u1 + u2).ToString());
                Console.WriteLine("Różnica: " + (u1 - u2).ToString());
                Console.WriteLine("Iloczyn: " + (u1 * u2).ToString());
                Console.WriteLine("Iloraz: " + (u1 / u2).ToString());

                Console.WriteLine();

                //Ułamek odwrotny = Ułamek.ObliczOdwrotny(u);
                Ułamek odwrotny = u.Odwrotność();

                Console.WriteLine();

                Console.WriteLine("Zero: " + Ułamek.Zero);
                Console.WriteLine("Połowa: " + Ułamek.Połowa);
                Console.WriteLine("Jeden: " + Ułamek.Jeden);

                Ułamek u3 = new Ułamek(3) + Ułamek.Połowa + Ułamek.Jeden;
                Console.WriteLine("u3=" + u3);
                Console.WriteLine("u3=" + u3.ToDouble());
                Console.WriteLine("u3=" + (double)u3);

                Console.WriteLine("0.1+1/3=" + (0.1 + (double)new Ułamek(1, 3)));

                Ułamek u4 = 3 + Ułamek.Połowa;
                Console.WriteLine("u4=" + u4);

                //rozszerzenia
                Rozsrzerzenia.PiszWartośćWKonsoli(u3);
                u3.PiszWartośćWKonsoli();
            }
            catch (Exception exc)
            {
                Console.WriteLine("Błąd: " + exc.Message);
            }
        }

        static void TestPers()
        {
            Pers miauczek = new Pers();
            miauczek.Miauczy("cokolwiek");
            miauczek.Głaskaj(false);

            Kot miauczekJakoKot = (Kot)miauczek;
            miauczekJakoKot.Miauczy("coś"); //metoda
        }

        static void TestSamochódOsobowy()
        {
            SamochódOsobowy samochód = new SamochódOsobowy();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.DodajPasażera();
            samochód.WłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 1;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 0;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WyłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WysadźPasażera();
            Console.WriteLine("Stan samochodu: " + samochód);
        }

        static void Main(string[] args)
        {
            TestSzablonKlasy();
            Console.WriteLine();
            TestKlasyVsStruktury();
            Console.WriteLine();
            TestKot();
            Console.WriteLine();
            TestSamochód();
            Console.WriteLine();
            TestUłamek();
            Console.WriteLine();
            TestPers();
            Console.WriteLine();
            TestSamochódOsobowy();

        } //koniec metody Main
    } //koniec klasy Program

    static class Rozsrzerzenia
    {
        static public void PiszWartośćWKonsoli(this Ułamek u)
        {
            Console.WriteLine("Wartość ułamka: " + u.ToString());            
        }

        static public void GłosSamochodu(this Samochód s)
        {
            Console.WriteLine("Brrrrrrrr....");
        }
    }
} //koniec przestrzeni nazw
