﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ProgramowanieObiektowe
{
    struct Ułamek
    {
        /*
        private int licznik;        

        public int Licznik
        {
            get
            {
                return licznik;
            }
            set
            {
                licznik = value;
            }
        }
        */

        public int Licznik { get; set; } //auto-implemented property


        private int mianownik;

        public int Mianownik
        {
            get
            {
                return mianownik;
            }
            set
            {
                if (value == 0) throw new DivideByZeroException("Mianownik nie może być równy zeru");
                else mianownik = value;
            }
        }

        /*
        //tak robi to kompilator
        public Ułamek()
        {
            Licznik = default(int);
            Mianownik = default(int);
        }
        */

        public override string ToString()
        {
            return Licznik + "/" + Mianownik;
        }

        public void UstalWartość(int licznik, int mianownik)
        {
            this.Licznik = licznik;
            this.Mianownik = mianownik;
        }

        public Ułamek(int licznik, int mianownik = 1)
            : this() //domyślna inicjacja
        {
            UstalWartość(licznik, mianownik);
        }

        /*
        public static Ułamek Dodaj(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);            
        }
        */

        public static Ułamek operator +(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);            
        }

        public static Ułamek operator -(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public static Ułamek operator -(Ułamek u)
        {
            return new Ułamek(-u.Licznik, u.Mianownik);
        }

        public static Ułamek operator *(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Licznik, u1.Mianownik * u2.Mianownik);
        }

        public static Ułamek operator /(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik, u1.Mianownik * u2.Licznik);            
        }

        /*
        public static Ułamek ObliczOdwrotny(Ułamek u)
        {
            return new Ułamek(u.Mianownik, u.Licznik);
        }
        */

        public Ułamek Odwrotność()
        {
            return new Ułamek(Mianownik, Licznik);
        }

        public readonly static Ułamek Zero = new Ułamek(0, 1);
        public readonly static Ułamek Połowa = new Ułamek(1, 2);
        public readonly static Ułamek Jeden = new Ułamek(1, 1);

        public double ToDouble()
        {
            return (double)Licznik / (double)Mianownik;
        }

        public static explicit operator double(Ułamek u)
        {
            return u.ToDouble();
        }

        public static implicit operator Ułamek(int licznik)
        {
            return new Ułamek(licznik);
        }
    }
}
