﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kadry
{
    enum Płeć { Mężczyzna, Kobieta };

    //OsobaZameldowana jest Osobą
    //OsobaZameldowana ma adres

    class Osoba
    {
        public int Pesel;
        public string Imię;
        public string Nazwisko;
        public int Wiek;
        public Płeć Płeć;        
    }

    class KodPocztowy
    {
        int OkręgPocztowy;
        int SektorKodowy;

        public override string ToString()
        {
 	        return OkręgPocztowy.ToString()+"-"+SektorKodowy.ToString();
        }
    }

    class Adres
    {
        public string Kraj;
        public string Miasto;
        public KodPocztowy KodPocztowy;
        public string Ulica;
        public string NumerDomu;
        public string NumerMieszkania;        
    }

    class OsobaZameldowana : Osoba
    {
        public Adres Adres;
    }

    class Program
    {
        static void Main(string[] args)
        {
            /*
            Osoba o2 = new Osoba();
            o2.Imię = "Jacek";
            o2.Nazwisko = "Matulewski";
            o2.Pesel = 123456789;
            o2.Wiek = 41;
            o2.Płeć = Płeć.Mężczyzna;

            Osoba o1 = new Osoba() { Imię = "Jacek", Nazwisko = "Matulewski", Pesel = 123456789, Wiek = 41, Płeć = Płeć.Mężczyzna };

            int[] ti = new int[3] { 0, 1, 2 };
            */

            Osoba[] rodzina = new Osoba[4]
            {
                new Osoba() { Imię = "Katarzyna", Nazwisko = "Matulewska", Pesel = 123456789, Wiek = 42, Płeć = Płeć.Kobieta },
                new Osoba() { Imię = "Jacek", Nazwisko = "Matulewski", Pesel = 123456789, Wiek = 41, Płeć = Płeć.Mężczyzna },
                new Osoba() { Imię = "Karolina", Nazwisko = "Matulewska", Pesel = 123456789, Wiek = 13, Płeć = Płeć.Kobieta },
                new Osoba() { Imię = "Bartek", Nazwisko = "Matulewski", Pesel = 123456789, Wiek = 8, Płeć = Płeć.Mężczyzna }
            };

            var osobyPełnoletnie = from Osoba o in rodzina //wskazanie typu elementu nie jest konieczne
                                   where o.Wiek>=18
                                   select o;

            Console.WriteLine("Osoby pełnoletnie:");
            foreach (Osoba o in osobyPełnoletnie)
            {
                Console.WriteLine(o.Imię + " " + o.Nazwisko);
            }
            Console.WriteLine();

            var kobietyPełnoletniePosortowaneAlfabetycznie = from o in rodzina
                                                             where o.Płeć == Płeć.Kobieta && o.Wiek >= 18
                                                             orderby o.Nazwisko+o.Imię
                                                             select o;

            Console.WriteLine("Kobiety pełnoletnie:");
            foreach (Osoba o in kobietyPełnoletniePosortowaneAlfabetycznie)
            {
                Console.WriteLine(o.Imię + " " + o.Nazwisko);
            }
            Console.WriteLine();

            var personaliaKobiet = from o in rodzina
                                   where o.Płeć == Płeć.Kobieta
                                   select o.Imię + " " + o.Nazwisko;

            Console.WriteLine("Personalia kobiet:");
            foreach (string s in personaliaKobiet)
            {
                Console.WriteLine(s);
            }
            Console.WriteLine();

            var rodzinaPosrtowanaWiekiem = from o in rodzina
                                           orderby o.Wiek
                                           select o;
        }
    }
}
