﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ParallelDemo
{
    class Program
    {
        static void CzasochłonnaAkcja()
        {
            CzasochłonnaAkcja(0);
        }

        static void CzasochłonnaAkcja(int i = 0)
        {
            //Console.WriteLine("Indeks pętli: " + i.ToString());
            double wynik = 0;
            for(int j =0;j<1000000;++j)
            {
                wynik = Math.Sin(Math.Atan(Math.Asin(Math.Sinh(1.0))));
            }
        }        

        static void Main(string[] args)
        {
            //Zrownoleglanie pętli
            Console.WriteLine("Uruchamiam obliczenia sekwencyjne...");
            long poczatek = System.Environment.TickCount;
            for (int i = 0; i < 100; ++i)
            {
                CzasochłonnaAkcja(i);
            }
            long koniec = System.Environment.TickCount;
            long czasObliczenSekwencyjnych = koniec - poczatek;
            Console.WriteLine("Obliczenia sekwencyjne zajęły " + czasObliczenSekwencyjnych.ToString() + " ms");

            Console.WriteLine("Uruchamiam obliczenia równoległe...");
            poczatek = System.Environment.TickCount;
            Parallel.For(0, 100, (int i) => { CzasochłonnaAkcja(i); });
            koniec = System.Environment.TickCount;
            long czasObliczenRownoleglych = koniec - poczatek;
            Console.WriteLine("Obliczenia równoległe zajęły " + (koniec - poczatek).ToString() + " ms");

            Console.WriteLine("Ilość rdzeni CPU: "+System.Environment.ProcessorCount.ToString());
            Console.WriteLine("Przyspieszenie: "+(1.0*czasObliczenSekwencyjnych/czasObliczenRownoleglych).ToString());

            //Zrownoleglanie dowolnych działań
            Action[] akcje = new Action[10];
            for (int i = 0; i < akcje.Length; ++i) akcje[i] = (Action)CzasochłonnaAkcja;
            Parallel.Invoke(akcje);
        }
    }
}
