﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Populacja
{
    class Program
    {
        class Miasto
        {
            private int populacja = 0;
            private double? przyrost = null;

            public Miasto(int populacja)
            {
                this.populacja = populacja;
            }

            public int Populacja
            {
                get
                {
                    return populacja;
                }
            }

            public double Przyrost
            {
                get
                {
                    if (!przyrost.HasValue) throw new Exception("Przyrost nie ma ustalonej wartości");
                    else return przyrost.Value;
                }
                set
                {
                    przyrost = value;
                }
            }

            public void ObliczPopulacjePoUplywieRoku()
            {
                if (!przyrost.HasValue) throw new Exception("Obliczenie nowej populacji nie jest możliwe. Przyrost nie ma ustalonej wartości");
                else populacja = (int)((1 + przyrost.Value) * populacja);
            }
        }

        static void Main(string[] args)
        {
            Miasto T = new Miasto(100000) { Przyrost = 0.03 };
            Miasto B = new Miasto(300000) { Przyrost = 0.02 };
            //T.Przyrost = 0.03;
            //B.Przyrost = 0.02;

            int rok = 2014;
            do
            {
                rok++;
                T.ObliczPopulacjePoUplywieRoku();
                B.ObliczPopulacjePoUplywieRoku();
                Console.WriteLine("Rok: " + rok.ToString() + ", T: " + T.Populacja.ToString() + ", B: " + B.Populacja.ToString());
            }
            while (T.Populacja < B.Populacja);
            Console.Out.WriteLine("Populacja miasta T. przekroczyła populację miasta B.");
        }
    }
}
