﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SortowanieBabelkowe
{
    class Program
    {
        const int liczbaElementów = 15;
        const int maksymalnaWartość = 100;

        static void zamienWartosci(ref int i, ref int j)
        {
            int tmp = i;
            i = j;
            j = tmp;
        }                

        static void wyswietlWartosciTablicy(int[] tablica)
        {
            string s = "";
            for (int i = 0; i < tablica.Length; ++i) s += tablica[i].ToString() + "; ";
            Console.WriteLine(s);
        }

        static void Main(string[] args)
        {
            Random r = new Random();

            int[] tablica = new int[liczbaElementów];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.Next(maksymalnaWartość);

            bool jeszczeNiePosortowane = true;
            int krokSortowania = 0;
            do
            {
                wyswietlWartosciTablicy(tablica);
                //MessageBox.Show("Krok sortowania "+krokSortowania.ToString());
                jeszczeNiePosortowane = false;
                for (int i = 0; i < tablica.Length - 1 - krokSortowania; ++i)
                {
                    if (tablica[i + 1] < tablica[i])
                    {
                        zamienWartosci(ref tablica[i], ref tablica[i + 1]);
                        jeszczeNiePosortowane = true;
                    }
                }
                krokSortowania++;
            }
            while (jeszczeNiePosortowane);
        }        
    }
}
