﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r = new Random();

        static double obliczPi(long liczbaPrób)
        {
            double x, y;
            long ilośćTrafień = 0;
            for(long i=0; i<liczbaPrób;++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) ilośćTrafień++;
            }
            return 4.0 * ilośćTrafień / liczbaPrób;
        }

        static void uruchamianieObliczenPi()
        {
            try
            {
                Console.WriteLine("Uruchamiam obliczenia w wątku {0}", Thread.CurrentThread.ManagedThreadId);

                int czasPoczątkowy = Environment.TickCount;

                long liczbaPrób = 1000000000L;
                double pi = obliczPi(liczbaPrób);

                int czasKońsowy = Environment.TickCount;

                Console.WriteLine("Pi={0}, błąd={1}", pi, Math.Abs(pi - Math.PI));
                Console.WriteLine("Czas obliczeń: " + (czasKońsowy - czasPoczątkowy).ToString() + " ms przeprowadzonych w wątku {0}", Thread.CurrentThread.ManagedThreadId);
            }
            catch(ThreadAbortException exc)
            {
                Console.WriteLine("Działąnie wątku zostało przerwane z zewnątrz (" + exc.Message + ")");
            }
            catch(Exception exc)
            {
                Console.WriteLine("Nieokreślony błąd (" + exc.Message + ")");
            }
            finally
            {
                Console.WriteLine("Zakończenie pracy wątku");
            }
        }

        static void Main(string[] args)
        {
            Console.WriteLine("Uruchamian program, wątek główny: " + Thread.CurrentThread.ManagedThreadId.ToString());

            //uruchamianieObliczenPi();

            //ThreadStart ts = uruchamianieObliczenPi;
            //Thread t = new Thread(ts);

            Thread t = new Thread(uruchamianieObliczenPi);
            //t.IsBackground = true;
            t.Priority = ThreadPriority.Highest;            
            t.Start();

            Thread.Sleep(1000);
            t.Suspend(); //przestarzałe
            Console.Write("Wątek wstrzymany. Naciśnij ENTER, aby go wznowić..."); Console.ReadLine();
            t.Resume(); //przestarzałe
            Console.WriteLine("Wątek wznowiony");

            Console.WriteLine("Naciśnij ENTER aby przerwać wątek..."); Console.ReadLine();
            t.Abort();

            Console.WriteLine("Czy to pojawi się po zakończeniu obliczeń?");
        }
    }
}
