﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r = new Random();

        //static double pi = 0;
        const long liczbaPróbWWątku = 1000000000L;
        static long całkowitaLiczbaTrafień = 0L;

        static long obliczPi(long liczbaPrób)
        {
            Random r = new Random(Program.r.Next());

            double x, y;
            long ilośćTrafień = 0;
            for(long i=0; i<liczbaPrób;++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) ilośćTrafień++;
            }
            return ilośćTrafień;
        }

        static void uruchamianieObliczenPi(object parametr)
        {
            try
            {
                int? indeks = parametr as int?;

                Console.WriteLine("Uruchamiam obliczenia w wątku {0}, indeks: {1}", Thread.CurrentThread.ManagedThreadId, (indeks.HasValue?indeks.Value.ToString():"---"));

                int czasPoczątkowy = Environment.TickCount;

                /*
                long liczbaPrób = 1000000000L;
                double pi = obliczPi(liczbaPrób);
                lock(r) Program.pi += pi;
                */
                long liczbaTrafień = obliczPi(liczbaPróbWWątku);
                //lock(r) całkowitaLiczbaTrafień += liczbaTrafień;
                Interlocked.Add(ref całkowitaLiczbaTrafień, liczbaTrafień);

                int czasKońsowy = Environment.TickCount;

                //Console.WriteLine("Pi={0}, błąd={1}", pi, Math.Abs(pi - Math.PI));
                Console.WriteLine("Czas obliczeń: " + (czasKońsowy - czasPoczątkowy).ToString() + " ms przeprowadzonych w wątku {0}", Thread.CurrentThread.ManagedThreadId);

                ewht[indeks.Value].Set();
            }
            catch(ThreadAbortException exc)
            {
                Console.WriteLine("Działąnie wątku zostało przerwane z zewnątrz (" + exc.Message + ")");
            }
            catch(Exception exc)
            {
                Console.WriteLine("Nieokreślony błąd (" + exc.Message + ")");
            }
            finally
            {
                Console.WriteLine("Zakończenie pracy wątku");
            }
        }

        const int ileWątków = 10;

        static EventWaitHandle[] ewht = new EventWaitHandle[ileWątków];

        static void Main(string[] args)
        {
            Console.WriteLine("Uruchamian program, wątek główny: " + Thread.CurrentThread.ManagedThreadId.ToString());
            Console.WriteLine("Liczba wątków: " + ileWątków.ToString());

            ThreadPool.SetMaxThreads(30, 100);
            for (int i = 0; i < ileWątków; i++)
            {
                ewht[i] = new EventWaitHandle(false, EventResetMode.AutoReset);
                ThreadPool.QueueUserWorkItem(uruchamianieObliczenPi, i);
            }

            for (int i = 0; i < ileWątków; ++i) ewht[i].WaitOne();

            //pi /= ileWątków;
            double pi = 4.0 * całkowitaLiczbaTrafień / (liczbaPróbWWątku * ileWątków);
            Console.WriteLine("Uśredniona wartość liczby pi: " + pi.ToString() + ", błąd: " + Math.Abs(pi - Math.PI).ToString());


            Console.WriteLine("Czy to pojawi się po zakończeniu obliczeń?");
        }
    }
}
