﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Bank
{
    class Program
    {
        class Konto
        {
            private decimal saldo;
            private long id;

            public Konto(decimal saldoPoczątkowe, int id)
            {
                saldo = saldoPoczątkowe;
                this.id = id;
            }

            public void WyświetlSaldo()
            {
                Console.WriteLine("Saldo konta {0}: {1}", id, saldo);
            }

            public void Wyplata(decimal kwota)
            {
                if (saldo - kwota < 0) throw new ArgumentException("Brak środków na koncie do zrealizowania wypłaty");
                saldo -= kwota;
                Console.WriteLine("Wypłacono {0} zł z konta {1}", kwota, id);
            }

            public void Wplata(decimal kwota)
            {
                saldo += kwota;
                Console.WriteLine("Wpłacono {0} zł na konto {1}", kwota, id);
            }

            private static void Przelew(Konto kontoPłatnika, Konto kontoOdbiorcy, decimal kwota)
            {
                if (kontoOdbiorcy.id == kontoPłatnika.id) throw new Exception("Niemożliwe wykonanie przelewu na to samo konta");

                Konto kontoA, kontoB; //tymczasowe referencje
                if (kontoPłatnika.id < kontoOdbiorcy.id)
                {
                    kontoA = kontoPłatnika;
                    kontoB = kontoOdbiorcy;
                }
                else
                {
                    kontoB = kontoPłatnika;
                    kontoA = kontoOdbiorcy;
                }

                lock (kontoA)
                {
                    Thread.Sleep(1000);
                    lock (kontoB)
                    {                        
                        Console.WriteLine("Przygotowanie do przelewu z konta {0} na konto {1}", kontoPłatnika.id, kontoOdbiorcy.id);
                        kontoPłatnika.WyświetlSaldo(); kontoOdbiorcy.WyświetlSaldo();
                        Thread.Sleep(1000);
                        kontoPłatnika.Wyplata(kwota);
                        kontoOdbiorcy.Wplata(kwota);
                        kontoPłatnika.WyświetlSaldo(); kontoOdbiorcy.WyświetlSaldo();
                        Console.WriteLine("Przelew został sfinalizowany");
                    }                    
                }                
            }

            public static void Przelew(Przelew przelew)
            {
                try
                {
                    if (przelew.czyZrealizowany) throw new Exception("Ten przelew został już zrealizowany");
                    Przelew(przelew.KontoPłatnika, przelew.KontoOdbiorcy, przelew.kwota);
                    przelew.czyZrealizowany = true;
                }
                catch(Exception exc)
                {
                    Console.Error.WriteLine("Błąd podczas wykonywania przelewu: " + exc.Message);
                    //throw new Exception("Błąd podczas wykonywania przelewu", exc);                                        
                }
            }            
        }

        class Przelew //wzorzec projektowy Command
        {
            public Konto KontoPłatnika;
            public Konto KontoOdbiorcy;
            public decimal kwota;
            public bool czyZrealizowany = false;
        }

        static List<Przelew> listaPrzelewow = new List<Przelew>();

        static void Main(string[] args)
        {
            Konto k1 = new Konto(100, 1);
            Konto k2 = new Konto(200, 2);

            /*
            k1.Wplata(10);
            k1.WyświetlSaldo(); k2.WyświetlSaldo();
            k2.Wyplata(50);
            k1.WyświetlSaldo(); k2.WyświetlSaldo();
            k1.Wyplata(300);
            k1.WyświetlSaldo(); k2.WyświetlSaldo();
            */

            //Konto.Przelew(k1, k2, 50);

            /*
            Przelew p1 = new Przelew() { KontoPłatnika = k1, KontoOdbiorcy = k2, kwota = 50 };
            Konto.Przelew(p1);
            Console.WriteLine("Czy przelew zrealizowany: " + (p1.czyZrealizowany ? "tak" : "nie"));
            */

            //WaitCallback transakcja =
            //ParameterizedThreadStart transakcja =
            Action<object> transakcja =
                (object parametr) =>
                {
                    Console.WriteLine("Numer wątku: " + Thread.CurrentThread.ManagedThreadId + ", numer zadania: " + Task.CurrentId);
                    Przelew p1 = parametr as Przelew;
                    //int indeksPrzelewu = (int)parametr; Przelew p1 = listaPrzelewow.ElementAt(indeksPrzelewu);
                    if (p1 == null) Console.Error.WriteLine("Brak lub niepoprawne polecenie przelewu");
                    //if (p1 == null) throw new Exception("Brak lub niepoprawne polecenie przelewu");
                    else Konto.Przelew(p1);
                };

            try
            {
                //Konto.Przelew(p1);
                //Console.WriteLine("Czy przelew zrealizowany: " + (p1.czyZrealizowany ? "tak" : "nie"));

                /*
                ThreadPool.QueueUserWorkItem(transakcja, new Przelew() { KontoPłatnika = k1, KontoOdbiorcy = k2, kwota = 45 });
                //ThreadPool.QueueUserWorkItem(transakcja, new Przelew() { KontoPłatnika = k1, KontoOdbiorcy = k2, kwota = 30 });
                ThreadPool.QueueUserWorkItem(transakcja, new Przelew() { KontoPłatnika = k2, KontoOdbiorcy = k1, kwota = 55 });
                */
                
                listaPrzelewow.Add(new Przelew() { KontoPłatnika = k1, KontoOdbiorcy = k2, kwota = 45 });
                listaPrzelewow.Add(new Przelew() { KontoPłatnika = k2, KontoOdbiorcy = k1, kwota = 55 });
                //for (int i = 0; i < listaPrzelewow.Count; ++i) new Thread(transakcja).Start(i);
                Task[] zadania = new Task[2];
                for (int i = 0; i < listaPrzelewow.Count; ++i)
                {
                    zadania[i]= new Task(transakcja, (object)(listaPrzelewow.ElementAt(i)));
                    zadania[i].Start();
                }
                //Task.WaitAny(zadania);
                //Console.WriteLine("Skończyłem pierwszy przelew");
                Task.WaitAll(zadania);
                //Console.WriteLine("Skończyłem wszystkie przelewy");
                for (int i = 0; i < listaPrzelewow.Count; ++i) zadania[i].ContinueWith(
                    (Task t) => 
                        {
                            Console.WriteLine("Numer wątku: " + Thread.CurrentThread.ManagedThreadId + ", numer zadania: " + Task.CurrentId);
                            Console.WriteLine("Kontynuacja w zadaniu " + Task.CurrentId + " po zadaniu " + t.Id);
                        });
            }
            catch(Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }

            Console.WriteLine("Naciśnij dowolny klawisz"); Console.ReadLine();
        }
    }
}
