﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RownanieKwadratoweBiblioteka
{
    public class RownanieKwadratowe
    {
        private double a = 0, b = 0, c = 0;
        private double? delta_pierwiastek = null;

        public bool CzyPierwiastkiIstnieja { get; private set; }

        //tu własności publiczne tylko do odczytu

        public RownanieKwadratowe(double a, double b = 0, double c = 0)
        {
            this.a = a;
            this.b = b;
            this.c = c;

            double delta = this.delta();
            CzyPierwiastkiIstnieja = delta >= 0;
            if(CzyPierwiastkiIstnieja) delta_pierwiastek = Math.Sqrt(delta);
        }

        private double delta()
        {
            return b * b - 4 * a * c;
        }

        private double DeltaPierwiastek
        {
            get
            {
                if (delta_pierwiastek.HasValue)
                    return delta_pierwiastek.Value;
                else throw new Exception("Delta jest ujemna, pierwiastek jest liczbą urojoną");
            }
        }

        //zrobić indexeer (widgit)

        public double X1
        {
            get
            {
                return (-b - DeltaPierwiastek) / 2 / a;
            }
        }

        public double X2
        {
            get
            {
                return (-b + DeltaPierwiastek) / 2 / a;
            }
        }
    }
}
