﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel;

namespace ObservableList_INotifyPropertyChanged
{
    class NotyfiningList<T> : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(PropertyChangedEventArgs e)
        {
            if (PropertyChanged != null) PropertyChanged(this, e);
        }

        List<T> lista = new List<T>();

        public void Add(T item)
        {
            lista.Add(item);
            OnPropertyChanged(new PropertyChangedEventArgs("Count"));
        }

        public void Remove(T item)
        {
            lista.Remove(item);
            OnPropertyChanged(new PropertyChangedEventArgs("Count"));
        }

        public void RemoveAt(int index)
        {
            lista.RemoveAt(index);
            OnPropertyChanged(new PropertyChangedEventArgs("Count"));
        }

        public void Move(int oldIndex, int newIndex)
        {
            if (oldIndex == newIndex) return;
            T item = lista.ElementAt(oldIndex);
            lista.Insert(newIndex, item);
            if (oldIndex < newIndex) lista.RemoveAt(oldIndex);
            else lista.RemoveAt(oldIndex + 1);
        }

        public int Count
        {
            get
            {
                return lista.Count;
            }
        }
    }
}
