﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.ObjectModel;

namespace ObservableList_INotifyPropertyChanged
{
    class Program
    {
        class Osoba
        {
            public string Imię;
            public string Nazwisko;
            public int Wiek;
        }

        static void Main(string[] args)
        {
            List<Osoba> lista = new List<Osoba>();
            lista.Add(new Osoba() { Imię = "Dominik", Nazwisko = "Blek", Wiek = 28 });
            lista.Add(new Osoba() { Imię = "Waldemar", Nazwisko = "Brodowski", Wiek = 46 });
            lista.Add(new Osoba() { Imię = "Marcin", Nazwisko = "Chabowski", Wiek = 36 });
            lista.Add(new Osoba() { Imię = "Łukasz", Nazwisko = "Dobowsiewicz", Wiek = 29 });            

            ObservableCollection<Osoba> listaObserwabla = new ObservableCollection<Osoba>();
            listaObserwabla.CollectionChanged += listaObserwabla_CollectionChanged;
            listaObserwabla.Add(new Osoba() { Imię = "Dominik", Nazwisko = "Blek", Wiek = 28 });
            listaObserwabla.Add(new Osoba() { Imię = "Waldemar", Nazwisko = "Brodowski", Wiek = 46 });
            listaObserwabla.Add(new Osoba() { Imię = "Marcin", Nazwisko = "Chabowski", Wiek = 36 });
            listaObserwabla.Add(new Osoba() { Imię = "Łukasz", Nazwisko = "Dobowsiewicz", Wiek = 29 });
            listaObserwabla.Move(1, 0);
            listaObserwabla.RemoveAt(1);

            NotyfiningList<Osoba> listaPowiadamiająca = new NotyfiningList<Osoba>();
            //listaPowiadamiająca.CollectionChanged += listaPowiadamiająca_CollectionChanged;
            listaPowiadamiająca.PropertyChanged += listaPowiadamiająca_PropertyChanged;
            listaPowiadamiająca.Add(new Osoba() { Imię = "Dominik", Nazwisko = "Blek", Wiek = 28 });
            listaPowiadamiająca.Add(new Osoba() { Imię = "Waldemar", Nazwisko = "Brodowski", Wiek = 46 });
            listaPowiadamiająca.Add(new Osoba() { Imię = "Marcin", Nazwisko = "Chabowski", Wiek = 36 });
            listaPowiadamiająca.Add(new Osoba() { Imię = "Łukasz", Nazwisko = "Dobowsiewicz", Wiek = 29 });
            listaPowiadamiająca.Move(1, 0);
            listaPowiadamiająca.RemoveAt(1);
        }
        
        static void listaObserwabla_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            Console.Write("Nastąpiła zmiana w kolekcji: ");
            switch(e.Action)
            {
                case System.Collections.Specialized.NotifyCollectionChangedAction.Add:
                    Console.WriteLine("dodano {0} elementów", e.NewItems.Count);
                    break;
                case System.Collections.Specialized.NotifyCollectionChangedAction.Remove:
                    Console.WriteLine("usunięto {0} elementów", e.OldItems.Count);
                    break;
                default:
                    Console.WriteLine("wykonano inną operacja", e.OldItems.Count);
                    break;
            }
        }

        static void listaPowiadamiająca_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            //Console.WriteLine("Zmiana własności Count, nowa wartość: " + (sender as NotyfiningList<Osoba>).Count.ToString());
            Console.WriteLine("Zmiana własności {0}, nowa wartość: {1}", e.PropertyName, sender.GetType().GetProperty(e.PropertyName).GetValue(sender));
        }

    }
}
