﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using Kolory.Resources;

using System.IO.IsolatedStorage;
using System.Windows.Media;


namespace Kolory
{
    public partial class MainPage : PhoneApplicationPage
    {
        public const string klucz = "Kolor";

        IsolatedStorageSettings ustawienia = IsolatedStorageSettings.ApplicationSettings;

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            // Sample code to localize the ApplicationBar
            //BuildLocalizedApplicationBar();
            Color? kolor = CzytajUstawienia();
            if (kolor.HasValue)
            {
                ZmieńKolor(kolor.Value);
                SliderR.Value = kolor.Value.R;
                SliderG.Value = kolor.Value.G;
                SliderB.Value = kolor.Value.B;
            }
            else MessageBox.Show("Pierwsze uruchomienie");
        }

        void ZmieńKolor(Color kolor) 
        {
            (rectangle.Fill as SolidColorBrush).Color = kolor;
        }

        void ZapiszUstawienia(Color kolor)
        {
            ustawienia[klucz] = kolor; //w razie potrzeby samo wywoła Add
        }

        Color? CzytajUstawienia()
        {
            if (ustawienia.Contains(klucz)) return (Color)ustawienia[klucz];
            else return null;
        }

        private void Sliders_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            if (rectangle == null) return;

            Color kolor = Color.FromArgb(255, (byte)SliderR.Value, (byte)SliderG.Value, (byte)SliderB.Value);
            ZmieńKolor(kolor);
            ZapiszUstawienia(kolor);
        }

        // Sample code for building a localized ApplicationBar
        //private void BuildLocalizedApplicationBar()
        //{
        //    // Set the page's ApplicationBar to a new instance of ApplicationBar.
        //    ApplicationBar = new ApplicationBar();

        //    // Create a new button and set the text value to the localized string from AppResources.
        //    ApplicationBarIconButton appBarButton = new ApplicationBarIconButton(new Uri("/Assets/AppBar/appbar.add.rest.png", UriKind.Relative));
        //    appBarButton.Text = AppResources.AppBarButtonText;
        //    ApplicationBar.Buttons.Add(appBarButton);

        //    // Create a new menu item with the localized string from AppResources.
        //    ApplicationBarMenuItem appBarMenuItem = new ApplicationBarMenuItem(AppResources.AppBarMenuItemText);
        //    ApplicationBar.MenuItems.Add(appBarMenuItem);
        //}
    }
}