﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RysowanieNaFormie
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public static float Lerp(float wartość1, float wartość2, float współczynnik)
        {
            return współczynnik * wartość1 + (1 - współczynnik) * wartość2;
        }

        public static Color Lerp(Color kolor1, Color kolor2, float współczynnik)
        {
            int r = (int)Lerp(kolor1.R, kolor2.R, współczynnik);
            int g = (int)Lerp(kolor1.G, kolor2.G, współczynnik);
            int b = (int)Lerp(kolor1.B, kolor2.B, współczynnik);
            return Color.FromArgb(r, g, b);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            /*
            e.Graphics.DrawString(
                "Studia podyplomowe UMK sposobem na udane życie!", 
                new Font(FontFamily.GenericSerif,10,FontStyle.Regular),
                Brushes.BlueViolet, 
                10, 10);
            */

            Color kolorGóra = Color.Cyan;
            Color kolorDół = Color.Magenta;
            for (int iy = 0; iy < ClientRectangle.Height; ++iy)
            {
                Color kolor = Lerp(kolorDół, kolorGóra, iy / (float)ClientRectangle.Height);
                e.Graphics.DrawLine(new Pen(kolor), 0, iy, ClientRectangle.Width, iy);
            }
        }

        private void Form1_ResizeEnd(object sender, EventArgs e)
        {
            Refresh();
        }
    }

    /*
    static class Rozszerzenia
    {
        public static Color Lerp(this Color kolor, Color innyKolor, float współczynnik)
        {
            int r = (int)(współczynnik * kolor.R + (1-współczynnik)* innyKolor.R);
            int g = (int)(współczynnik * kolor.G + (1-współczynnik)* innyKolor.G);
            int b = (int)(współczynnik * kolor.B + (1-współczynnik)* innyKolor.B);
            return Color.FromArgb(r, g, b);
        }
    }
    */
}
