﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using Microsoft.Win32;

namespace Ustawienia
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        const string nazwaKlucza = "Software\\UMK\\Ustawienia";

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (nieZapisujUstawień) return;

            try
            {
                RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza, true);
                if (rejestr == null)
                {
                    rejestr = Registry.CurrentUser.CreateSubKey(nazwaKlucza);
                }
                rejestr.SetValue("Left", this.Left);
                rejestr.SetValue("Top", this.Top);
                rejestr.SetValue("Width", this.Width);
                rejestr.SetValue("Height", this.Height);
                rejestr.SetValue("Text", this.Text);
                rejestr.Close();
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            textBox1.Text = this.Text; //na wypadek, gdyby nie udało się odczytać klucza

            RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza, false);
            if (rejestr == null) return;
            if (!rejestr.GetValueNames().Contains("Text")) return;
            this.Left = (int)rejestr.GetValue("Left");
            this.Top = (int)rejestr.GetValue("Top");
            this.Width = (int)rejestr.GetValue("Width");
            this.Height = (int)rejestr.GetValue("Height");
            this.Text = (string)rejestr.GetValue("Text");
            textBox1.Text = this.Text;
            label1.Text = "Klucz rejestru Windows: " + rejestr.Name;
            rejestr.Close();
        }

        bool nieZapisujUstawień = false;

        private void button1_Click(object sender, EventArgs e)
        {
            Registry.CurrentUser.DeleteSubKey(nazwaKlucza);
            nieZapisujUstawień = true;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            this.Text = textBox1.Text;
        }
    }
}
