﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

//using Ustawienia.Properties; //ustawienia aplikacji
//using Microsoft.Win32; //rejestr
using System.Xml.Linq; //LINQ to XML

namespace Ustawienia
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //Settings ustawienia = new Settings();        
        //const string nazwaKlucza = "Software\\UMK\\Ustawienia";
        string ścieżkaDoPlikuXml = "Ustawienia.xml";

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            /*
            ustawienia.Left = this.Left;
            ustawienia.Top = this.Top;
            ustawienia.Width = this.Width;
            ustawienia.Height = this.Height;
            ustawienia.Text = this.Text;
            ustawienia.Save();
            */

            /*
            try
            {
                RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza, true);
                if (rejestr == null)
                {
                    rejestr = Registry.CurrentUser.CreateSubKey(nazwaKlucza);
                }
                rejestr.SetValue("Left", this.Left);
                rejestr.SetValue("Top", this.Top);
                rejestr.SetValue("Width", this.Width);
                rejestr.SetValue("Height", this.Height);
                rejestr.SetValue("Text", this.Text);
                rejestr.Close();
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
            */

            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XComment("Ustawienia aplikacji"),
                new XElement("opcje", //korzeń
                    new XElement("okno",
                        new XAttribute("nazwa", this.Text),
                        new XElement("pozycja",
                            new XElement("X", this.Left),
                            new XElement("Y", this.Top)
                        ),
                        new XElement("rozmiar",
                            new XElement("X", this.Width),
                            new XElement("Y", this.Height)
                        ) //koniec rozmiar
                    ) //koniec okno
                ) //koniec opcje
            ); //koniec XDocument

            xml.Save(ścieżkaDoPlikuXml);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            /*
            this.Left = ustawienia.Left;
            this.Top = ustawienia.Top;
            this.Width = ustawienia.Width;
            this.Height = ustawienia.Height;
            this.Text = ustawienia.Text;
            */

            /*
            RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza, false);
            if (rejestr == null) return;
            if (!rejestr.GetValueNames().Contains("Text")) return;
            this.Left = (int)rejestr.GetValue("Left");
            this.Top = (int)rejestr.GetValue("Top");
            this.Width = (int)rejestr.GetValue("Width");
            this.Height = (int)rejestr.GetValue("Height");
            this.Text = (string)rejestr.GetValue("Text");
            rejestr.Close();
            */

            try
            {
                XDocument xml = XDocument.Load(ścieżkaDoPlikuXml);

                XElement pozycja = xml.Root.Element("okno").Element("pozycja");
                this.Left = int.Parse(pozycja.Element("X").Value);
                this.Top = int.Parse(pozycja.Element("Y").Value);

                XElement rozmiar = xml.Root.Element("okno").Element("rozmiar");
                this.Width = int.Parse(rozmiar.Element("X").Value);
                this.Height = int.Parse(rozmiar.Element("Y").Value);
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd:  " + exc.Message);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Registry.CurrentUser.DeleteSubKey(nazwaKlucza);
            System.IO.File.Delete(ścieżkaDoPlikuXml);            
        }
    }
}
