﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaZBazaDanych
{
    public partial class Form2 : Form
    {
        public Form2()
        {
            InitializeComponent();
            button2_Click(null, null);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //pobieranie danych z tabeli
            BazaDanychDataContext bazaDanychDataContext = new BazaDanychDataContext();
            //var osoby = bazaDanychDataContext.Osobas;

            //pobieranie kolekcji
            var listaOsóbPełnoletnich = from o in bazaDanychDataContext.Osobas
                                        where o.Wiek >= 18
                                        select o;

            //prezentacja
            string s = "Pobrana lista osób:\n";
            foreach (Osoba o in listaOsóbPełnoletnich) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            BazaDanychDataContext bazaDanychDataContext = new BazaDanychDataContext();

            dataGridView1.DataSource = bazaDanychDataContext.Osobas;

            comboBox1.DataSource = dataGridView1.DataSource;
            comboBox1.DisplayMember = "Email";
            comboBox1.ValueMember = "Id";

            if (textBox1.DataBindings.Count == 0)
            {
                textBox1.DataBindings.Add("Text", bazaDanychDataContext.Osobas, "Email");
                numericUpDown1.DataBindings.Add("Value", bazaDanychDataContext.Osobas, "Wiek");
            }
        }

        private void Form2_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
        }
    }
}
