﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Media;

namespace Choinka
{
    public partial class Form1 : Form
    {
        private Bitmap obraz = null;
        private SoundPlayer sp = new SoundPlayer("White_Christmas.wav");

        public Form1()
        {
            InitializeComponent();            
            
            obraz = new Bitmap("Choinka.png");
            obraz.MakeTransparent(Color.Fuchsia);
            this.Width = obraz.Width;
            this.Height = obraz.Height;

            notifyIcon1.Icon = this.Icon;

            sp.Play();
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            sp.Stop();
            notifyIcon1.Visible = false;
            if(!czyUkryty) for (; Opacity > 0; Opacity-=0.01) System.Threading.Thread.Sleep(10);
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
            //if (e.KeyChar == (char)27) this.Close();
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Escape: this.Close(); break;
                case Keys.Space: ukryjToolStripMenuItem_Click(null, null); break;
            }
        }

        private bool czyTrwaPrzenoszenie = false;
        private int x0, y0;

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                czyTrwaPrzenoszenie = true;
                x0 = e.X;
                y0 = e.Y;
                this.Cursor = Cursors.Hand;
            }
            if (e.Button == MouseButtons.Middle)
            {
                contextMenuStrip1.Show(this.Location.X+e.Location.X,this.Location.Y+e.Location.Y);
            }
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                Left += e.X - x0;
                Top += e.Y - y0;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                czyTrwaPrzenoszenie = false;
                this.Cursor = Cursors.Default;
            }
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void zawszeWidocznedToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.TopMost = zawszeWidocznedToolStripMenuItem.Checked;
        }

        private void przezroczystośćToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Opacity = przezroczystośćToolStripMenuItem.Checked?0.5:1.0;
        }

        private void usuńZPaskaZadańToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.ShowInTaskbar = !usuńZPaskaZadańToolStripMenuItem.Checked;
        }

        private bool czyUkryty = false;

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!czyUkryty)
            {
                czyUkryty = true;
                this.Hide();
                ukryjToolStripMenuItem.Text = "Pokaż";
            }
            else
            {
                czyUkryty = false;
                this.Show();
                ukryjToolStripMenuItem.Text = "Ukryj";
            }
        }

        private void stronaPSPiZKNETToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //System.Diagnostics.Process.Start("Choinka.png");
            System.Diagnostics.Process.Start("http://www.fizyka.umk.pl/wfaiis/?q=node/822");
        }

        private void stronaUMKToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.umk.pl/");
        }

        //private bool czyPodwojneKlikniecie = false;

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            /*
            //MessageBox.Show(czyPodwojneKlikniecie.ToString());            
            System.Threading.Thread.Sleep(500);
            //MessageBox.Show(czyPodwojneKlikniecie.ToString());

            if (e.Button == MouseButtons.Left && !czyPodwojneKlikniecie) ukryjToolStripMenuItem_Click(null, null);
            czyPodwojneKlikniecie = false;
            */
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            //if (e.Button == MouseButtons.Left) czyPodwojneKlikniecie = true;

            notifyIcon1.BalloonTipIcon = ToolTipIcon.None;
            notifyIcon1.BalloonTipText = "Wesołych Świąt i szczęśliwego Nowe Roku " + (DateTime.Now.Year + 1).ToString() + " \nżyczą studenci PSPiZK-NET";
            notifyIcon1.BalloonTipTitle = "Choinka";
            notifyIcon1.ShowBalloonTip(5000);
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            DateTime teraz = DateTime.Now;
            int iloscDniDoWigilii = (new DateTime(teraz.Year, 12, 24) - teraz).Days;
            notifyIcon1.Text = "Do Wigilii zostało jeszcze " + iloscDniDoWigilii + " dni";
        }
    }
}
