﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Net;
using System.IO;

namespace FTPKlient
{
    class FtpClient
    {
        public string Username;
        public string Password;

        private string ftpDirectory;

        public string FtpDirectory
        {
            get
            {
                if (!ftpDirectory.StartsWith("ftp://")) ftpDirectory = "ftp://" + ftpDirectory;
                return ftpDirectory;
            }
            set
            {
                ftpDirectory = value;
                if (ftpDirectory[ftpDirectory.Length - 1] == '/') ftpDirectory.Remove(ftpDirectory.Length - 1);
            }
        }

        public List<string> ListParentDirectory()
        {
            FtpDirectory = FtpDirectory.Remove(FtpDirectory.LastIndexOf('/'));
            return ListDirectory();
        }

        public List<string> ListSubDirectory(string subdirectory)
        {
            FtpDirectory += "/" + subdirectory;
            return ListDirectory();
        }

        public FtpClient(string ftpDirectory, string username = "anonymous", string password = "fake@address.com")
        {
            this.FtpDirectory = ftpDirectory;
            this.Username = username;
            this.Password = password;
        }

        public List<string> ListDirectory()
        {
            List<string> entries = new List<string>();
            FtpWebRequest request;
            try
            {
                request = (FtpWebRequest)WebRequest.Create(FtpDirectory);
                request.Method = WebRequestMethods.Ftp.ListDirectoryDetails;
                request.Credentials = new NetworkCredential(Username, Password);
                request.KeepAlive = false;
                using(FtpWebResponse response = (FtpWebResponse) request.GetResponse())
                {
                    Stream s = response.GetResponseStream();
                    using (StreamReader sr = new StreamReader(s))
                    {
                        string entry;
                        while((entry = sr.ReadLine()) != null)
                        {
                            entries.Add(entry);
                        }                        
                    }
                }
                //entries.Sort(); //tu sortuje się śmieci
                return entries;
            }
            catch(Exception exc)
            {
                throw new Exception("Nie można nawiązać połączenia z serwerem FTP: " + FtpDirectory, exc);
            }
        }

        public void DownloadFile(string remoteFilePath, string localFilePath)
        {
            WebClient client = new WebClient();
            try
            {
                Uri uri = new Uri(remoteFilePath);
                if (File.Exists(localFilePath)) throw new IOException("Plik lokalny " + localFilePath + " już istnieje");
                else
                {
                    client.Credentials = new NetworkCredential(Username, Password);
                    client.DownloadFile(uri, localFilePath);                    
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                client.Dispose();
            }
        }
    }
}
