﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Windows.UI;
using System.ComponentModel;

namespace KoloryWP8.ModelWidoku
{
    public class WybórKoloru : INotifyPropertyChanged
    {
        private Model.Kolor kolor = new Model.Kolor(0, 255, 255);

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                OnPropertyChanged("G", "Color");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                //OnPropertyChanged(new string[] { "R", "Color" });
                OnPropertyChanged("B", "Color");
            }
        }

        public Color Color
        {
            get
            {
                return Color.FromArgb(255, R, G, B);
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged!=null)
            {
                foreach(string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(
                        this, 
                        new PropertyChangedEventArgs(nazwaWłasności));
            }
        }
    }

    public class WybórKoloru2
    {
        public byte R { get; set; }
        public byte G { get; set; }
        public byte B { get; set; }

        public WybórKoloru2()
        {
            Model.Kolor kolor = new Model.Kolor(255, 255, 255);
            R = kolor.R;
            G = kolor.G;
            B = kolor.B;
        }
    }

    public class WybórKoloru3
    {
        public Model.Kolor Kolor = new Model.Kolor(255, 255, 255);
    }
}
