﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AsystentSklepowyWPF.Model;
using System.Windows.Input;
using System.Windows;
using System.ComponentModel;

namespace AsystentSklepowyWPF.ModelWidoku
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        AutoSumowanie model = new AutoSumowanie(1000);

        public string Suma
        {
            get 
            { 
                return Convert.ToString(model.Suma); 
            }
        }

        /*
        public string Kwota
        {
            get
            {
                return kwota.ToString();
            }
            set
            {
                try
                {
                    kwota = decimal.Parse(value);
                }
                catch
                {
                    kwota = 0; MessageBox.Show("Popraw Kwotę");
                }
            }
        }
        */

        private bool CzyŁańcuchKwotyJestPoprawny(string s)
        {
            decimal kwota;
            if (string.IsNullOrWhiteSpace(s)) return false;            
            if (!decimal.TryParse(s, out kwota)) return false;
            else return model.CzyKwotaPoprawna(kwota);
        }

        ICommand dodajKwoteCommand;

        public ICommand DodajKwoteCommand
        {
            get
            {
                if (dodajKwoteCommand == null)
                    dodajKwoteCommand = new RelayCommand(
                        (object argument) =>
                        {
                            try
                            {
                                decimal kwota = decimal.Parse((string)argument);
                                model.Dodaj(kwota);
                                kwota = 0;
                                OnpropertyChanged("Suma");
                                OnpropertyChanged("Kwota");
                            }
                            catch (ArgumentException exc)
                            {
                                //MessageBox.Show("Za duża kwota");
                                throw new ArgumentException("Za duża kwota", exc);
                            }
                        },
                        (object argument) =>
                        {
                            return CzyŁańcuchKwotyJestPoprawny((string)argument);
                        });
                return dodajKwoteCommand;
            }
        }

        /*
        public ICommand WyświetlKomunikat
        {
            get
            {
                return new RelayCommand(
                    argument => 
                    { 
                        MessageBox.Show(argument.ToString()); 
                    });
            }
        }
        */

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnpropertyChanged(string nazwaWłasnosci)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasnosci));

        }
    }
}
