﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using Windows.Globalization;
using Windows.Globalization.DateTimeFormatting;
using Windows.UI;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

namespace ZadaniaUA
{
    public class BoolToBrushConverter : IValueConverter
    {
        public Brush KolorDlaFałszu { get; set; }
        public Brush KolorDlaPrawdy { get; set; }

        public BoolToBrushConverter()
        {
            //KolorDlaFałszu = Brushes.Black;
            //KolorDlaPrawdy = Brushes.Gray;
            KolorDlaFałszu = new SolidColorBrush(Colors.Black);
            KolorDlaPrawdy = new SolidColorBrush(Colors.Gray);
        }

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            bool b = (bool)value;
            return !b ? KolorDlaFałszu : KolorDlaPrawdy;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class PriorytetZadaniaToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)value;
            return Model.Zadanie.OpisPriorytetu(priorytet);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            string opis = (value as string).ToLower();
            return Model.Zadanie.ParsujOpisPriorytetu(opis);
        }
    }

    public class PriorytetZadaniaToBrushConverter : IValueConverter
    {
        private Brush brushMniejWażne = new SolidColorBrush(Colors.Olive);
        private Brush brushWażne = new SolidColorBrush(Colors.Orange);
        private Brush brushKrytyczne = new SolidColorBrush(Colors.OrangeRed);

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            Model.PriorytetZadania priorytetZadania = (Model.PriorytetZadania)value;
            switch(priorytetZadania)
            {
                case Model.PriorytetZadania.MniejWażne:
                    return brushMniejWażne;
                case Model.PriorytetZadania.Ważne:
                    return brushWażne;
                case Model.PriorytetZadania.Krytyczne:
                    return brushKrytyczne;
                default:
                    throw new Exception("Nierozpoznany priorytet zadania");
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    /*
    public class BoolToTextDecorationConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            bool b = (bool)value;
            return !b ? TextDecorations.Strikethrough : null;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class ZadanieConverter : IMultiValueConverter
    {
        PriorytetZadaniaToStringConverter pzts = new PriorytetZadaniaToStringConverter();

        public object Convert(object[] values, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            string opis = (string)values[0];
            DateTime terminUtworzenia = DateTime.Now;
            DateTime? planowanyTerminRealizacji = (DateTime?)values[1];
            Model.PriorytetZadania priorytet = 
                (Model.PriorytetZadania)pzts.ConvertBack(
                    values[2], typeof(Model.PriorytetZadania), 
                    null, System.Globalization.CultureInfo.CurrentCulture);
            if (!string.IsNullOrWhiteSpace(opis) && planowanyTerminRealizacji.HasValue)
                return new ModelWidoku.Zadanie(opis, terminUtworzenia, planowanyTerminRealizacji.Value, priorytet, false);
            else return null;
        }
    
        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
    */

    public class BoolToVisibleConverter : IValueConverter
    {
        public bool OdwróćZależność { get; set; }


        public object Convert(object value, Type targetType, object parameter, string language)
        {
            bool b = (bool)value;
            if (OdwróćZależność) b = !b;
            return b ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class DateConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            if (value == null || !(value is DateTime)) return null;

            DateTime dt = (DateTime)value;
            DateTimeFormatter dtf = new DateTimeFormatter(
                YearFormat.Full,
                MonthFormat.Full,
                DayFormat.Default,
                DayOfWeekFormat.None,
                HourFormat.None,
                MinuteFormat.None,
                SecondFormat.None,
                new string[] { "pl-PL" },
                "PL",
                CalendarIdentifiers.Gregorian,
                ClockIdentifiers.TwentyFourHour);
            return dtf.Format(dt);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }
}
