﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using Windows.Storage;

namespace ZadaniaUA.Model
{
    public static class PlikXml
    {
        public static async Task<bool> ZapiszAsync(string nazwaPliku, Zadania zadania)
        {
            try
            {
                XDocument xml = new XDocument(                    
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data zapisania: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie zadanie in zadania
                        select new XElement("Zadanie",
                            new XElement("Opis", zadanie.Opis),
                            new XElement("DataUtworzenia", zadanie.DataUtworzenia),
                            new XElement("PlanowanyTerminRealizacji", zadanie.PlanowanyTerminRealizacji),
                            new XElement("Priorytet", (byte)zadanie.Priorytet),
                            new XElement("CzyZrealizowane", zadanie.CzyZrealizowane.ToString()))
                            )
                    );
                //xml.Save(ścieżkaPliku);
                string zawartośćXml = xml.ToString();
                StorageFile plik =
                    await ApplicationData.Current.LocalFolder.CreateFileAsync(
                        nazwaPliku,
                        CreationCollisionOption.OpenIfExists);
                if (plik != null)
                {
                    await FileIO.WriteTextAsync(plik, zawartośćXml);
                    return true;
                }
                else return false;
            }
            catch //(Exception exc)
            {
                //throw new Exception("Błąd przy zapisie danych do pliku XML", exc);
                return false;
            }
        }

        public static async Task<Zadania> CzytajAsync(string nazwaPliku)
        {
            try
            {
                //XDocument xml = XDocument.Load(nazwaPliku);
                StorageFile plik = await ApplicationData.Current.LocalFolder.GetFileAsync(nazwaPliku);
                if (plik != null)
                {

                    string zawartośćXml = await FileIO.ReadTextAsync(plik);

                    XDocument xml = XDocument.Parse(zawartośćXml);
                    IEnumerable<Zadanie> dane =
                        from zadanie in xml.Root.Descendants("Zadanie")
                        select new Zadanie(
                            zadanie.Element("Opis").Value,
                            DateTime.Parse(zadanie.Element("DataUtworzenia").Value),
                            DateTime.Parse(zadanie.Element("PlanowanyTerminRealizacji").Value),
                            (PriorytetZadania)byte.Parse(zadanie.Element("Priorytet").Value),
                            bool.Parse(zadanie.Element("CzyZrealizowane").Value));
                    Zadania zadania = new Zadania();
                    foreach (Zadanie zadanie in dane) zadania.DodajZadanie(zadanie);
                    return zadania;
                }
                else return null;
            }
            catch //(Exception exc)
            {
                //throw new Exception("Błąd przy odczycie danych z pliku XML", exc);
                return null;
            }
        }
    }
}
