﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Windows.Input;
using System.Windows;

namespace ZadaniaUA.ModelWidoku
{
    public class Zadania
    {
        //private const string ścieżkaPlikuXml = "zadania.xml";
        public const string NazwaPlikuXml = "zadania.xml";

        //przechowywanie dwóch kolekcje
        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; private set; }

        private void KopiujZadania()
        {
            ListaZadań.CollectionChanged -= SynchronizacjaModelu;
            ListaZadań.Clear();
            foreach (Model.Zadanie zadanie in model)
                ListaZadań.Add(new Zadanie(zadanie));
            ListaZadań.CollectionChanged += SynchronizacjaModelu;
        }

        private async void Inicjuj()
        {
            model = await Model.PlikXml.CzytajAsync(NazwaPlikuXml);
            if (model == null) model = new Model.Zadania();

            /*
            //fakeowe dane
            if (model.Count() == 0)
            {
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Pierwsze",
                        DateTime.Now, DateTime.Now.AddDays(2),
                        Model.PriorytetZadania.Ważne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Drugie",
                        DateTime.Now, DateTime.Now.AddDays(5),
                        Model.PriorytetZadania.Krytyczne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Trzecie",
                        DateTime.Now, DateTime.Now.AddDays(1),
                        Model.PriorytetZadania.MniejWażne));
            }
            */

            KopiujZadania();
        }

        public Zadania()
        {
            ListaZadań = new ObservableCollection<Zadanie>();

            Inicjuj();
        }

        private void SynchronizacjaModelu(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = (Zadanie)e.NewItems[0];
                    if(noweZadanie != null)
                        model.DodajZadanie(noweZadanie.GetModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = (Zadanie)e.OldItems[0];
                    if (usuwaneZadanie != null)
                        model.UsuńZadanie(usuwaneZadanie.GetModel());
                    break;
            }
        }

        private ICommand zapiszCommand;

        public ICommand Zapisz
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new RelayCommand(
                        async argument =>
                        {
                            await Model.PlikXml.ZapiszAsync(NazwaPlikuXml, model);
                        });
                return zapiszCommand;
            }
        }

        private ICommand usuńZadanie;

        public ICommand UsuńZadanie
        {
            get
            {
                if (usuńZadanie == null)
                {
                    usuńZadanie = new RelayCommand(
                        o =>
                        {
                            int indeksZadania = (int)o;
                            Zadanie zadanie = ListaZadań[indeksZadania];
                            /*
                            if (!zadanie.CzyZrealizowane)
                            {
                                MessageBoxResult mbr = MessageBox.Show("Czy jesteś pewien?", "Zadania", MessageBoxButton.YesNo, MessageBoxImage.Question, MessageBoxResult.No);
                                if (mbr == MessageBoxResult.No) return;
                            }
                            */
                            ListaZadań.Remove(zadanie);
                        },
                        o =>
                        {
                            if (o == null) return false;
                            int indeksZadania = (int)o;
                            return indeksZadania >= 0;
                        });
                }
                return usuńZadanie;
            }
        }

        private ICommand dodajZadanie;

        public ICommand DodajZadanie
        {
            get
            {
                if (dodajZadanie == null)
                {
                    dodajZadanie = new RelayCommand(
                        o =>
                        {
                            Zadanie zadanie = o as Zadanie;
                            if (zadanie != null) ListaZadań.Add(zadanie);
                        },
                        o =>
                        {
                            return (o as Zadanie) != null;
                        });
                }
                return dodajZadanie;
            }
        }

        private ICommand sortujZadania;

        public ICommand SortujZadania
        {
            get
            {
                if (sortujZadania == null)
                    sortujZadania = new RelayCommand(
                        o =>
                        {
                            bool poCzymSortować = bool.Parse((string)o);
                            model.SortujZadania(poCzymSortować);
                            KopiujZadania();
                        });
                return sortujZadania;
            }
        }
    }
}
