﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kontrolki
{
    public partial class AlarmControl : UserControl
    {
        public AlarmControl()
        {
            InitializeComponent();

            DateTime teraz = DateTime.Now;
            nudGodziny.Value = teraz.Hour;
            nudMinuty.Value = teraz.Minute + 1;
        }

        public DateTime CzasAlarmu 
        {
            get
            {
                DateTime dziś = DateTime.Today;
                return new DateTime(
                    dziś.Year, dziś.Month, dziś.Day,
                    (int)nudGodziny.Value, (int)nudMinuty.Value, 0);
            }
            set
            {
                nudGodziny.Value = value.Hour;
                nudMinuty.Value = value.Minute;
            }
        }

        public bool AlarmWłączony
        {
            get
            {
                return checkBox1.Checked;
            }
            set
            {
                checkBox1.Checked = value;
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (!checkBox1.Checked)
            {
                label1.Text = "Wyłączony";
                label1.ForeColor = Color.Navy;
                return;
            }

            DateTime teraz = DateTime.Now;
            //if (teraz.Hour >= CzasAlarmu.Hour && teraz.Minute >= CzasAlarmu.Minute)
            if(teraz >= CzasAlarmu)
            {
                label1.Text = "Alarm!";
                label1.ForeColor = Color.Red;
                button1.Enabled = true;
                OnAlarm(this,new EventArgs());
            }
            else
            {
                label1.Text = "Czuwanie";
                label1.ForeColor = Color.Green;
                button1.Enabled = false;
            }
        }

        public void Drzemka()
        {
            CzasAlarmu = DateTime.Now.AddMinutes(9);            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            button1.Enabled = false;
            Drzemka();
        }

        public delegate void AlarmEventHandler(object sender, EventArgs e);

        public event AlarmEventHandler Alarm;

        private void OnAlarm(object sender, EventArgs e)
        {
            if (Alarm != null)
                Alarm(sender, e);

        }
    }
}
