﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WyrazeniaLambda_LINQ
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        static int kwadrat1(int x)
        {
            return x*x;
        }

        delegate int TypKwadrat(int x);        

        private void button1_Click(object sender, EventArgs e)
        {
            int y = kwadrat1(1);
            MessageBox.Show("x^2=" + y);

            TypKwadrat kwadrat2 = kwadrat1;
            y = kwadrat2(2);
            MessageBox.Show("x^2=" + y);

            TypKwadrat kwadrat3 = (int x) => { return x * x; };
            y = kwadrat3(3);
            MessageBox.Show("x^2=" + y);

            TypKwadrat kwadrat4 = (x) => x * x;
            y = kwadrat4(4);
            MessageBox.Show("x^2=" + y);

            Func<int,int> kwadrat5 = (x) => x * x;
            y = kwadrat5(5);
            MessageBox.Show("x^2=" + y);

            Action<object> pokaż = (x) => MessageBox.Show(x.ToString());
            pokaż(y);
            pokaż(kwadrat5);
            pokaż(pokaż);            
        }

        //-----------------------------------------------

        class Osoba : ICloneable //klasa encji
        {
            public int Id;
            public string Imię;
            public string Nazwisko;
            public int Wiek;
            public string NumerTelefonu;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }

            public object Clone()
            {
                return new Osoba() 
                { 
                    Id = this.Id, 
                    Imię = this.Imię, 
                    Nazwisko = this.Nazwisko, 
                    Wiek = this.Wiek, 
                    NumerTelefonu = this.NumerTelefonu 
                };
            }
        };

        List<Osoba> osoby = new List<Osoba>()
        {
            new Osoba() {Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", Wiek = 42, NumerTelefonu = "123456789"},
            new Osoba() {Id = 1, Imię = "Dorota", Nazwisko = "Masłowska", Wiek = 18, NumerTelefonu = "606606606"},
            new Osoba() {Id = 2, Imię = "Małgorzata", Nazwisko = "Bednarczuk", Wiek = 18, NumerTelefonu = "67777777"},
            new Osoba() {Id = 4, Imię = "Zofia", Nazwisko = "Kulbicka", Wiek = 30, NumerTelefonu = "55555555"},
            new Osoba() {Id = 3, Imię = "Agata", Nazwisko = "Kulbicka", Wiek = 26, NumerTelefonu = "55555555"}
            
        };

        private void button2_Click(object sender, EventArgs e)
        {
            var kobietyPelnoletnie = from osoba in osoby
                                     where osoba.Wiek >= 18 && osoba.Imię.EndsWith("a")
                                     //orderby osoba.Nazwisko, osoba.Imię
                                     orderby osoba.Nazwisko.Length descending
                                     select osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")";
            kobietyPelnoletnie = kobietyPelnoletnie.ToList();

            osoby.ElementAt(4).Nazwisko = "Masłowska";

            string s = "Wynik zapytania:\n";
            foreach(string osoba in kobietyPelnoletnie)
            {
                s += osoba + "\n";
            }
            MessageBox.Show(s);

            //wybrać nazwiska osób, które mają od 20 do 50 lat, 
            //ułożyć zgodnie z drugą literą imienia

            var zapytanie2 = from o in osoby
                             where o.Wiek >= 20 && o.Wiek <= 50
                             orderby o.Imię[1]
                             select o.Nazwisko;

            s = "Wynik zapytania:\n";
            foreach (string osoba in zapytanie2)
            {
                s += osoba + "\n";
            }
            MessageBox.Show(s);

            //-----------------------------

            var kobietyPelnoletnie2 = osoby
                .Where((osoba) => osoba.Wiek >= 18 && osoba.Imię.EndsWith("a"))
                //.Where((osoba) => osoba.Wiek >= 18)
                //.Where((osoba) => osoba.Imię.EndsWith("a"))
                .OrderByDescending((osoba) => osoba.Nazwisko.Length)
                .Select((osoba) => osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")");

            s = "Wynik zapytania:\n";
            foreach (string osoba in kobietyPelnoletnie2)
            {
                s += osoba + "\n";
            }
            MessageBox.Show(s);

            var zapytanie22 = osoby
                .Where(o => o.Wiek>=20 && o.Wiek<=50)
                .OrderBy(o => o.Imię[1])
                .Select((o) => o.Nazwisko);            

            s = "Wynik zapytania:\n";
            foreach (string osoba in zapytanie22)
            {
                s += osoba + "\n";
            }
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var zapytanie3 = from o in osoby
                             orderby o.Nazwisko
                             //select o;                             
                             //select new Osoba() { Id = o.Id, Imię = o.Imię, Nazwisko = o.Nazwisko, Wiek = o.Wiek, NumerTelefonu = o.NumerTelefonu };
                             select (Osoba)o.Clone();
                             //select new { Identyfikator = o.Id, Wiek = o.Wiek };
            zapytanie3 = zapytanie3.ToList();

            Osoba osobaOstatnia = zapytanie3.Last();
            osobaOstatnia.Imię = "Bartek";
            osobaOstatnia.Wiek = 9;

            string s = "Wynik zapytania:\n";
            foreach (Osoba osoba in zapytanie3)
            {
                s += osoba.ToString() + "\n";
            }
            MessageBox.Show(s);

            s = "Oryginalna kolekcja:\n";
            foreach (Osoba osoba in osoby)
            {
                s += osoba.ToString() + "\n";
            }
            MessageBox.Show(s);
        }
    }
}
