﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace TestyJednostkowe
{
    using TestyJednostkowePowtórzenie;

    [TestClass]
    public class UnitTestKlasy
    {
        [TestMethod]
        public void TestKonstruktora()
        {
            Klasa obiekt = new Klasa();

            Assert.IsNotNull(obiekt);
        }

        [TestMethod]
        public void TestMetodyStatycznej()
        {
            int wynik = Klasa.MetodaStatyczna(1);
            Assert.AreEqual(1, wynik);
        }

        [TestMethod]
        public void TestMetody()
        {
            int wynik = new Klasa().Metoda(1);
            Assert.AreEqual(1, wynik);
        }

        [TestMethod]
        [ExpectedException(typeof(Exception))]
        public void TestMetodyZgłaszającejWyjątek()
        {
            int wynik = new Klasa().MetodaZgłaszającaWyjątek(1);
        }

        [TestMethod]
        public void TestMetodyZmieniającejPrywatnePoleIWłasności()
        {
            Klasa obiekt = new Klasa();

            obiekt.MetodaZmieniającaPrywatnePole(2);
            int wynik = obiekt.PublicznaWłasność;

            Assert.AreEqual(2, wynik);
        }

        [TestMethod]
        public void TestMetodyZmieniającejPrywatnePole()
        {
            Klasa obiekt = new Klasa();

            obiekt.MetodaZmieniającaPrywatnePole(2);

            PrivateObject po = new PrivateObject(obiekt);
            int wynik = (int)po.GetField("prywatnePole");

            Assert.AreEqual(2, wynik);
        }

    }
}
