﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KoloryWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            Color kolor = CzytajUstawienia();
            rectangle1.Fill = new SolidColorBrush(kolor);
            sliderR.Value = kolor.R;
            sliderG.Value = kolor.G;
            sliderB.Value = kolor.B;
        }

        private Color KolorProstokąta
        {
            get
            {
                return (rectangle1.Fill as SolidColorBrush).Color;
            }
            set
            {
                (rectangle1.Fill as SolidColorBrush).Color = value;
            }
        }

        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            KolorProstokąta = Color.FromRgb((byte)sliderR.Value, (byte)sliderG.Value, (byte)sliderB.Value); ;
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            ZapiszUstawienia(KolorProstokąta);
        }


        #region Ustawienia
        private static Color CzytajUstawienia()
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            return Color.FromRgb(ustawienia.R, ustawienia.G, ustawienia.B);
        }

        private static void ZapiszUstawienia(Color kolor)
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            ustawienia.R = kolor.R;
            ustawienia.G = kolor.G;
            ustawienia.B = kolor.B;
            ustawienia.Save();
        }
        #endregion
    }
}
