﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KoloryWPF.ViewModel
{
    public class Kolor
    {
        public byte R { get; set; }
        public byte G { get; set; }
        public byte B { get; set; }

        public Kolor()
        {
            CzytajUstawienia();
        }

        public Kolor(byte r, byte g, byte b)
        {
            this.R = r;
            this.G = g;
            this.B = b;
        }

        public void Zapisz()
        {
            ZapiszUstawienia(this);
        }

        #region Ustawienia
        private static Kolor CzytajUstawienia()
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            //return Color.FromRgb(ustawienia.R, ustawienia.G, ustawienia.B);
            return new Kolor(ustawienia.R, ustawienia.B, ustawienia.G);
        }

        private static void ZapiszUstawienia(Kolor kolor)
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            ustawienia.R = kolor.R;
            ustawienia.G = kolor.G;
            ustawienia.B = kolor.B;
            ustawienia.Save();
        }
        #endregion
    }
}
