﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel;
using System.Windows.Input;

namespace KoloryWPF.ViewModel
{
    public class Kolor : INotifyPropertyChanged
    {
        private byte r,g,b;

        public byte R 
        { 
            get
            {
                return r;
            } 
            set
            {
                r = value;
                OnPropertyChanged("R");
                OnPropertyChanged("This");
            }
        }

        public byte G
        {
            get
            {
                return g;
            }
            set
            {
                g = value;
                OnPropertyChanged("G");
                OnPropertyChanged("This");
            }
        }

        public byte B
        {
            get
            {
                return b;
            }
            set
            {
                b = value;
                OnPropertyChanged("B");
                OnPropertyChanged("This");
            }
        }

        public Kolor This
        {
            get
            {
                return this;
            }
        }

        public Kolor()
        {
            Czytaj();
        }

        public Kolor(byte r, byte g, byte b)
        {
            this.R = r;
            this.G = g;
            this.B = b;
        }

        public ICommand ZapiszCommand
        {
            get
            {
                return new RelayCommand((object argument) => { Zapisz(); });
            }
        }

        private void Zapisz()
        {
            ZapiszUstawienia(this);
        }

        private void Czytaj()
        {
            Kolor kolor = CzytajUstawienia();
            this.R = kolor.R;
            this.G = kolor.G;
            this.B = kolor.B;
        }

        #region Ustawienia
        private static Kolor CzytajUstawienia()
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            //return Color.FromRgb(ustawienia.R, ustawienia.G, ustawienia.B);
            return new Kolor(ustawienia.R, ustawienia.G, ustawienia.B);            
        }

        private static void ZapiszUstawienia(Kolor kolor)
        {
            Properties.Settings ustawienia = Properties.Settings.Default;
            ustawienia.R = kolor.R;
            ustawienia.G = kolor.G;
            ustawienia.B = kolor.B;
            ustawienia.Save();
        }
        #endregion

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string nazwaWłasności)
        {
            if(PropertyChanged!=null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }
    }
}
