﻿using System;

namespace AsystentSklepowyWPF.Model
{
    public class AutoSumowanie
    {
        private decimal limit;
        private decimal suma = 0;

        public AutoSumowanie(decimal limit)
        {
            this.limit = limit;
        }

        public void Dodaj(decimal kwota)
        {
            if (kwota < 0)
                throw new ArgumentException("Kwota nie może być ujemna");
            if (CzyPrzekroczyLimit(kwota))
                throw new ArgumentOutOfRangeException("Kwota zbyt duża");
            suma += kwota;
        }

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        public bool CzyPrzekroczyLimit(decimal kwota)
        {
            return suma + kwota > limit;
        }
    }
}
