﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

// konkurs 2. przegladarka rysunkow .net

namespace Przegladarka {

   public partial class Form1 : Form {

      #region fields/constructor

      private string filePath = "";
      private bool isPictureChanged = false;

      private BitmapEditor bitmapEditor; 
      private Bitmap pictureImage;
      private Bitmap tempImage;

      public Form1() {
         InitializeComponent();
         UstawTytulOkna();
      }

      #endregion

      private void Obrot(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;

         if (isPBoxNull()) {
            return;
         }

         ZainicjujEdycje();

         int kierunek = int.Parse(eventMenu.Tag.ToString());

         switch (kierunek) {
            case 1:
               pBox.Image.RotateFlip(RotateFlipType.Rotate270FlipNone);
               break;
            case 2:
               pBox.Image.RotateFlip(RotateFlipType.Rotate90FlipNone);
               break;
            case 3:
               pBox.Image.RotateFlip(RotateFlipType.Rotate180FlipNone);
               break;
            case 4:
               pBox.Image.RotateFlip(RotateFlipType.RotateNoneFlipX);
               break;
            case 5:
               pBox.Image.RotateFlip(RotateFlipType.RotateNoneFlipY);
               break;
         }
         pBox.Invalidate();
         isPictureChanged = true;
      }

      private void Powiekszenie(object sender, EventArgs e) {

         if (isPBoxNull()) {
            return;
         }

         WyczyscMenuPowiekszenie();
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         
         int factor = int.Parse(eventMenu.Tag.ToString());

         if (factor == 1) {
            if (pBox.Image.Width > pBox.Image.Height) {
               pBox.Height = this.Height;
               pBox.Width = pBox.Height * (pBox.Image.Width / pBox.Image.Height);
            }
            else {
               pBox.Height = pBox.Width * (pBox.Image.Height / pBox.Image.Width);
            }
         }
         else {
            pBox.Width = (int)(pBox.Image.Width * factor / 100);
            pBox.Height = (int)(pBox.Image.Height * factor / 100);
         }
         eventMenu.Checked = true;
                  
      }

      private void WyczyscMenuPowiekszenie() {
        foreach (ToolStripMenuItem itm in mnuWidokPowiekszenie.DropDownItems)
            itm.Checked = false;
      }

      #region file operations

      private void OpenContents(string fName = "") {

         try {
            if (string.IsNullOrEmpty(fName)) {
               openFileDialog.FileName = fName;
               DialogResult dg = openFileDialog.ShowDialog();
               if (dg == DialogResult.OK) {
                  filePath = openFileDialog.FileName;
               }
            }
            else {
               filePath = fName;
            }

            pictureImage = new Bitmap(filePath);
            pBox.Image = pictureImage;
            pBox.Refresh();

            UstawTytulOkna();
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad odczytu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
      }

      private bool SaveContents() {
         try {
            saveFileDialog.FileName = filePath;

            //saveFileDialog.DefaultExt = "bmp";
            saveFileDialog.Filter = "Windows Bitmap (*.bmp)|*.bmp|" +
                           "Graphics Interchange Format (*.gif)|*.gif|" +
                           "JPEG File Interchange Format (*.jpg)|" +
                              "*.jpg;*.jpeg;*.jfif|" +
                           "Tagged Imaged File Format (*.tif)|*.tif;*.tiff";

            DialogResult dg = saveFileDialog.ShowDialog();
            if (dg == DialogResult.OK) {
               filePath = saveFileDialog.FileName;
      
               string fileExt = Path.GetExtension(filePath);

               switch (fileExt) {
                  case ".bmp":
                     pBox.Image.Save(filePath, ImageFormat.Bmp);
                     break;
                  case ".gif":
                     pBox.Image.Save(filePath, ImageFormat.Gif);
                     break;
                  case ".jpg":
                     pBox.Image.Save(filePath, ImageFormat.Jpeg);
                     break;
                  case ".tif":
                     pBox.Image.Save(filePath, ImageFormat.Tiff);
                     break;
               }

               isPictureChanged = false;
               UstawTytulOkna();
               return true;
            }
            else if (dg == DialogResult.No) {
               WyczyscObraz();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad zapisu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool Save() {
         try {

            if (File.Exists(filePath)) {

               string fileExt = Path.GetExtension(filePath);

               switch (fileExt) {
                  case ".bmp":
                     pBox.Image.Save(filePath, ImageFormat.Bmp);
                     break;
                  case ".gif":
                     pBox.Image.Save(filePath, ImageFormat.Gif);
                     break;
                  case ".jpg":
                     pBox.Image.Save(filePath, ImageFormat.Jpeg);
                     break;
                  case ".tif":
                     pBox.Image.Save(filePath, ImageFormat.Tiff);
                     break;
               }

               isPictureChanged = false;
               //UstawTytulOkna();
               return true;
            }
            else {
               bool exit = SaveContents();
               return exit;
            }
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad zapisu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool SaveCurrent() {
         if (isPictureChanged == true) {
            DialogResult dg = MessageBox.Show("Zapisac biezacy?", "Zapisywanie", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
            if (dg == DialogResult.Yes) {
               return Save();
            }
            else if (dg == DialogResult.No) {
               WyczyscObraz();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         return true;
      }

      #endregion

      #region menu formatowanie


      #endregion

      #region menu plik

      private void mnuPlikOtworz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            OpenContents();
         }
      }

      private void mnuPlikZapiszJako_Click(object sender, EventArgs e) {
         SaveContents();
      }

      private void mnuPlikZakoncz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true)
            this.Close();
      }

      private void mnuPlikZapisz_Click(object sender, EventArgs e) {
         Save();
      }

      private void mnuPlikNowy_Click(object sender, EventArgs e) {
         SaveCurrent();
         WyczyscObraz();
      }

      #endregion

      #region edycja

      private void UstawTytulOkna() {
         string sciezkaPliku = "Nowy niezapisany plik";
         if (!(string.IsNullOrEmpty(filePath)))
            sciezkaPliku = Path.GetFileName(filePath);
         this.Text = sciezkaPliku + " - Przegladarka Obrazow .NET";
         if (isPictureChanged)
          this.Text += " w trakcie edycji";
        
      }

      private void WyczyscObraz() {
         filePath = "";
         pBox.Image = null;
         isPictureChanged = false;
         UstawTytulOkna();
         pBox.Size = new Size(800, 600);
      }

      #endregion

      #region form events

      private void Form1_FormClosing(object sender, FormClosingEventArgs e) {
         bool exit = SaveCurrent();
         if (exit == false)
            e.Cancel = true;
      }

      private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
         Properties.Settings.Default.FilePath = filePath;
         Properties.Settings.Default.Left = this.Left;
         Properties.Settings.Default.Top = this.Top;
         Properties.Settings.Default.Width = this.Width;
         Properties.Settings.Default.Height = this.Height;
         Properties.Settings.Default.Save();
      }

      private void Form1_Load(object sender, EventArgs e) {

         this.Left = Properties.Settings.Default.Left;
         this.Top = Properties.Settings.Default.Top;
         this.Width = Properties.Settings.Default.Width;
         this.Height = Properties.Settings.Default.Height;

         string fileFromProperties = Properties.Settings.Default.FilePath;
         if (File.Exists(fileFromProperties)) {
            filePath = fileFromProperties;
            OpenContents(filePath);
         }
      }

      #endregion


      private bool isPBoxNull() {
         if (pBox.Image == null) {
            MessageBox.Show(this,"Brak obrazu","Przegladarka .NET");
            return true;
         }
         return false;     
      }

      private void ZainicjujEdycje() {

         if (isPBoxNull()) {
            return;
         }

         pictureImage = new Bitmap(pBox.Image);
         pBox.Image = pictureImage;
         tempImage = new Bitmap(pBox.Image);
         pBox.Image = tempImage;
         bitmapEditor = new BitmapEditor();
      }

      private void OdwrocKolory(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         string wybor = eventMenu.Tag.ToString();
         if (isPBoxNull())
            return;
         ZainicjujEdycje();
         bitmapEditor.NegateColor(tempImage, mnuOpcjeUseSafe.Checked);
         pBox.Refresh();
         isPictureChanged = true;
      }

      private void Wyostrz(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         
         if (isPBoxNull())
            return;
         ZainicjujEdycje();
         bitmapEditor.Sharpen(tempImage, mnuOpcjeUseSafe.Checked);
         pBox.Refresh();
         isPictureChanged = true;
         
      }

      private void Wygladz(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         
         if (isPBoxNull())
            return;
         ZainicjujEdycje();
         bitmapEditor.Smooth(tempImage, mnuOpcjeUseSafe.Checked);
         pBox.Refresh();
         isPictureChanged = true;
      }

      private void Relief(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         
         if (isPBoxNull())
            return;
         ZainicjujEdycje();
         bitmapEditor.Emboss(tempImage, mnuOpcjeUseSafe.Checked);
         pBox.Refresh();
         isPictureChanged = true;
      }

      private void Rozmyj(object sender, EventArgs e) {
         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         
         if (isPBoxNull())
            return;
         ZainicjujEdycje();
         bitmapEditor.Diffuse(tempImage, mnuOpcjeUseSafe.Checked);
         pBox.Refresh();
         isPictureChanged = true;
      }

      private void mnuanulujZmiany_Click(object sender, EventArgs e) {
         
            pBox.Image = pictureImage;
            pBox.Refresh();
         
      }
       

   }
}