﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        Properties.Settings s = Properties.Settings.Default;
        public Form1()
        {
            InitializeComponent();
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {

            if (chkBW.Checked)
            {
                TrackBar tr = (TrackBar)sender;
                trackBarG.Value = trackBarB.Value = trackBarR.Value = tr.Value;
            }
                
            panel1.BackColor = Color.FromArgb(
                trackBarR.Value, 
                trackBarG.Value, 
                trackBarB.Value);
            labelR.Text = trackBarR.Value.ToString();
            labelG.Text = trackBarG.Value.ToString();
            labelB.Text = trackBarB.Value.ToString();
            tbxHEX.Text = kolorHEX();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            /*double krok = this.Opacity / 100;
            for (int i=0; i<100; i++)
            {
                this.Opacity -= krok;
                System.Threading.Thread.Sleep(1);
            }*/
            /*
            //zapisywanie ustawień
            Properties.Settings.Default.R = (byte)trackBarR.Value;
            Properties.Settings.Default.G = (byte)trackBarG.Value;
            Properties.Settings.Default.B = (byte)trackBarB.Value;
            Properties.Settings.Default.Top = Top;
            Properties.Settings.Default.Height = Height;
            Properties.Settings.Default.Left = Left;
            Properties.Settings.Default.Width = Width;
            Properties.Settings.Default.Save();
*/
            s.R = (byte)trackBarR.Value;
            s.G = (byte)trackBarG.Value;
            s.B = (byte)trackBarB.Value;
            s.Top = Top;
            s.Height = Height;
            s.Left = Left;
            s.Width = Width;
            s.Save();
            for (;Opacity>0;Opacity-=0.05) System.Threading.Thread.Sleep(1);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {

            if (trackBarR.Value == Properties.Settings.Default.R && trackBarB.Value == Properties.Settings.Default.B && trackBarG.Value == Properties.Settings.Default.G)
                return;
            DialogResult dr = MessageBox.Show(
                "Czy na pewno chcesz zamknąć aplikację?",
                this.Text,
                MessageBoxButtons.YesNo,
                MessageBoxIcon.Question);
            if (dr == DialogResult.No) e.Cancel = true;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            trackBarR.Value = 0;
            trackBarG.Value = 0;
            trackBarB.Value = 0;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBarR.Value = s.R;
            trackBarG.Value = s.G;
            trackBarB.Value = s.B;
            Width = s.Width;
            Top = s.Top;
            Left = s.Left;
            Height = s.Height;

        }

        private void button3_Click(object sender, EventArgs e)
        {
            string hex = "#"+kolorHEX();
            //MessageBox.Show(hex);
            Clipboard.SetText(hex);
        }

        private string kolorHEX()
        {
            //string hex = "#";
            string hex = "";
            hex += trackBarR.Value.ToString("X2");
            hex += trackBarG.Value.ToString("X2");
            hex += trackBarB.Value.ToString("X2");
            return hex;
        }

        private void btnWybKolor_Click(object sender, EventArgs e)
        {
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                //panel1.BackColor = colorDialog1.Color;
                trackBarR.Value = colorDialog1.Color.R;
                trackBarG.Value = colorDialog1.Color.G;
                trackBarB.Value = colorDialog1.Color.B;
            }
        }

        private void tbxHEX_TextChanged(object sender, EventArgs e)
        {
            string tekst = tbxHEX.Text;
            int n = 0;
            if (!int.TryParse(tekst, System.Globalization.NumberStyles.HexNumber, System.Globalization.NumberFormatInfo.CurrentInfo, out n) &&
              tekst != String.Empty)
            {
                tbxHEX.Text = tekst.Remove(tekst.Length - 1, 1);
                tbxHEX.SelectionStart = tbxHEX.Text.Length;
            }
            
        }

        private void tbxHEX_Leave(object sender, EventArgs e)
        {
            Txt2Color();
        }

        private void Txt2Color()
        {
            String tekst = tbxHEX.Text;
            if (tekst.Length < 6)
            {
                tekst = tekst.PadRight(6, '0');
                tbxHEX.SelectionStart = tbxHEX.Text.Length;
            }
            trackBarR.Value = int.Parse(tekst.Remove(2,4), System.Globalization.NumberStyles.HexNumber);
            trackBarG.Value = int.Parse(tekst.Remove(4, 2).Remove(0, 2), System.Globalization.NumberStyles.HexNumber);
            trackBarB.Value = int.Parse(tekst.Remove(0,4), System.Globalization.NumberStyles.HexNumber);
            tbxHEX.Text = tekst;
            
        }

        private void tbxHEX_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return) Txt2Color();
        }

        private void chkBW_CheckedChanged(object sender, EventArgs e)
        {
            if (chkBW.Checked)
            {
                int stan = (trackBarB.Value + trackBarG.Value + trackBarR.Value) / 3;
                trackBarR.Value = trackBarG.Value = trackBarB.Value = stan;
            }
        }
    }
}
