﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;



namespace Zadanie2_prostaPrzegladarkaGrafiki
{
    public partial class Form1 : Form
    {
        //string SciezkaPliku = "";
        public List<string> ListaPlikow = new List<string>();
        int z = 0;
        string SciezkaPliku = "";


        public Form1()
        {
            InitializeComponent();
        }

        private void otworzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.Title = "Wybierz pliki";
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    ListaPlikow.Clear();
                    //ListaPlikow.Add(openFileDialog1.FileName);
                    foreach (String file in openFileDialog1.FileNames)
                    {

                        ListaPlikow.Add(file);



                        // Set the image property.
                        //this.PictureBox1.Image = new Bitmap(typeof(Button), "Button.bmp");
                    }

                    pictureBox1.Image = Image.FromFile(ListaPlikow[0]);
                    textBox1.Text = (ListaPlikow[0]);
                    if (ListaPlikow.Count == 1)
                    {
                        ListaPlikow.Clear();
                    }
                }

                //pictureBox1.SizeMode = PictureBoxSizeMode.CenterImage;
                pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;

            }
            catch (Exception exc)
            {
                {
                    MessageBox.Show(
                        "Blad odczytu pliku !" + exc.Message,
                        this.Text,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }


            }
        }

        private void Nastepne_button_Click(object sender, EventArgs e)
        {
            if (ListaPlikow.Count > 1)
            {
                z++;

                if (z > ListaPlikow.Count()) z = 1;

                textBox1.Text = (ListaPlikow[(ListaPlikow.Count() - z)]);
                pictureBox1.Image = Image.FromFile(ListaPlikow[(ListaPlikow.Count() - z)]);
            }
        }

        private void Poprzednie_button_Click(object sender, EventArgs e)
        {
            if (ListaPlikow.Count > 1)
            {
                z--;

                if (z < 1) z = ListaPlikow.Count();

                textBox1.Text = (ListaPlikow[(ListaPlikow.Count() - z)]);
                pictureBox1.Image = Image.FromFile(ListaPlikow[(ListaPlikow.Count() - z)]);
            }
        }

        private void zamknij_ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Lewo_Click(object sender, EventArgs e)
        {

            Image img = pictureBox1.Image;
            img.RotateFlip(RotateFlipType.Rotate270FlipNone);
            pictureBox1.Image = img;
            //pictureBox1.SizeMode = PictureBoxSizeMode.CenterImage;
            pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
        }

        private void prawo_Click(object sender, EventArgs e)
        {
            Image img = pictureBox1.Image;
            img.RotateFlip(RotateFlipType.Rotate90FlipNone);
            pictureBox1.Image = img;
            //pictureBox1.SizeMode = PictureBoxSizeMode.CenterImage;
            pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
        }

//-----------------------------------------------------------------------------------------------------------

        Boolean bHaveMouse;
        Point ptOriginal = new Point();
        Point ptLast = new Point();
        Rectangle rectCropArea;

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {

            // Make a note that we "have the mouse". 
            bHaveMouse = true;

            // Store the "starting point" for this rubber-band rectangle. 
            ptOriginal.X = e.X;
            ptOriginal.Y = e.Y;

            // Special value lets us know that no previous 
            // rectangle needs to be erased. 

            // Display coordinates 
            textBox1.Text = "Coordinates  :  " + e.X.ToString() + ", " + e.Y.ToString();

            ptLast.X = -1;
            ptLast.Y = -1;

            rectCropArea = new Rectangle(new Point(e.X, e.Y), new Size());
        }


        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            // Set internal flag to know we no longer "have the mouse". 
            bHaveMouse = false;

            // If we have drawn previously, draw again in that spot 
            // to remove the lines. 
            if (ptLast.X != -1)
            {
                Point ptCurrent = new Point(e.X, e.Y);

                // Display coordinates 
                textBox1.Text = "Coordinates  :  " + ptOriginal.X.ToString() + ", " +
                    ptOriginal.Y.ToString() + " And " + e.X.ToString() + ", " + e.Y.ToString();

            }

            // Set flags to know that there is no "previous" line to reverse. 
            ptLast.X = -1;
            ptLast.Y = -1;
            ptOriginal.X = -1;
            ptOriginal.Y = -1;
        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            Point ptCurrent = new Point(e.X, e.Y);

            // If we "have the mouse", then we draw our lines. 
            if (bHaveMouse)
            {
                // If we have drawn previously, draw again in 
                // that spot to remove the lines. 
                if (ptLast.X != -1)
                {
                    // Display Coordinates 
                    textBox1.Text = "Coordinates  :  " + ptOriginal.X.ToString() + ", " +
                        ptOriginal.Y.ToString() + " And " + e.X.ToString() + ", " + e.Y.ToString();
                }

                // Update last point. 
                ptLast = ptCurrent;

                // Draw new lines. 

                // e.X - rectCropArea.X; 
                // normal 
                if (e.X > ptOriginal.X && e.Y > ptOriginal.Y)
                {
                    rectCropArea.Width = e.X - ptOriginal.X;

                    // e.Y - rectCropArea.Height; 
                    rectCropArea.Height = e.Y - ptOriginal.Y;
                }
                else if (e.X < ptOriginal.X && e.Y > ptOriginal.Y)
                {
                    rectCropArea.Width = ptOriginal.X - e.X;
                    rectCropArea.Height = e.Y - ptOriginal.Y;
                    rectCropArea.X = e.X;
                    rectCropArea.Y = ptOriginal.Y;
                }
                else if (e.X > ptOriginal.X && e.Y < ptOriginal.Y)
                {
                    rectCropArea.Width = e.X - ptOriginal.X;
                    rectCropArea.Height = ptOriginal.Y - e.Y;

                    rectCropArea.X = ptOriginal.X;
                    rectCropArea.Y = e.Y;
                }
                else
                {
                    rectCropArea.Width = ptOriginal.X - e.X;

                    // e.Y - rectCropArea.Height; 
                    rectCropArea.Height = ptOriginal.Y - e.Y;
                    rectCropArea.X = e.X;
                    rectCropArea.Y = e.Y;
                }
                pictureBox1.Refresh();
                
            }
        }
        private void Przytnij_Click(object sender, EventArgs e)
        {
            pictureBox1.Refresh();




            Bitmap sourceBitmap = new Bitmap(pictureBox1.Image, pictureBox1.Width, pictureBox1.Height);
            Graphics g = pictureBox1.CreateGraphics();

            if (!chkCropCordinates.Checked)
            {
                textBox1.Text = "";
                //string[] cordinates = tbCordinates.Text.ToString().Split(',');
                string[] cordinates = textBox1.Text.ToString().Split(',');
                int cord0, cord1, cord2, cord3;

                try
                {
                    cord0 = Convert.ToInt32(cordinates[0]);
                    cord1 = Convert.ToInt32(cordinates[1]);
                    cord2 = Convert.ToInt32(cordinates[2]);
                    cord3 = Convert.ToInt32(cordinates[3]);
                }
                catch (Exception ex)
                {
                    textBox1.Text = ex.Message;
                    return;
                }

                if ((cord0 < cord2 && cord1 < cord3))
                {
                    rectCropArea = new Rectangle(cord0, cord1, cord2 - cord0, cord3 - cord1);
                }
                else if (cord2 < cord0 && cord3 > cord1)
                {
                    rectCropArea = new Rectangle(cord2, cord1, cord0 - cord2, cord3 - cord1);
                }
                else if (cord2 > cord0 && cord3 < cord1)
                {
                    rectCropArea = new Rectangle(cord0, cord3, cord2 - cord0, cord1 - cord3);
                }
                else
                {
                    rectCropArea = new Rectangle(cord2, cord3, cord0 - cord2, cord1 - cord3);
                }
            }

            g.DrawImage(sourceBitmap, new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height),
                rectCropArea, GraphicsUnit.Pixel);
            sourceBitmap.Dispose();


        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (File.Exists(SciezkaPliku))
                {
                    saveFileDialog1.InitialDirectory = Path.GetDirectoryName(SciezkaPliku);
                    saveFileDialog1.FileName = Path.GetFileName(SciezkaPliku);
                }
                else
                {
                    saveFileDialog1.FileName = "";
                }

                //------------------------------------------------------------------------------------------
                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    textBox1.ReadOnly = false;
                    pictureBox1.Image.Save (saveFileDialog1.FileName,ImageFormat.Jpeg);
                    SciezkaPliku = saveFileDialog1.FileName;
                    textBox1.Text = "ZAPISANO..."+ SciezkaPliku;
                }

            }
            catch (Exception exc)
            {

                MessageBox.Show(
                    "Blad zapisu " + exc.Message,
                       this.Text,
                       MessageBoxButtons.OK,
                       MessageBoxIcon.Error);
                textBox1.Text = "NIE ZAPISANO !!!";
            }
        }









    }
}