﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Threading;

namespace Zima {
   public partial class Form1 : Form {

      private Bitmap bmp;
      private Graphics canvas;

      public Form1() {
         InitializeComponent();
         this.SetStyle(ControlStyles.AllPaintingInWmPaint
                     | ControlStyles.UserPaint | ControlStyles.DoubleBuffer, true);
         SetGraphicsObject();
         backgroundWorker.RunWorkerAsync();
      }
   
   	private void SetGraphicsObject()
	{
		bmp = new Bitmap (this.ClientRectangle.Width, this.ClientRectangle.Height);//, System.Drawing.Imaging.PixelFormat.Format24bppRgb);
		this.BackgroundImage = bmp;
		canvas = Graphics.FromImage(bmp);
	   
		canvas.SmoothingMode = SmoothingMode.HighQuality;
		canvas.CompositingQuality = CompositingQuality.HighQuality;
	}

      public delegate void InvokeRefreshDelegate();

      public void InvokeRefresh() {
         this.Refresh();
      }

	   public void Draw()
	{
		
      Slonce slonce = new Slonce();
      int sky = 255 - (int)(slonce.Y * 9) / 10;
      canvas.FillRectangle(new SolidBrush(Color.FromArgb(255,0,0,sky)), 0, 0, this.ClientSize.Width, this.ClientSize.Height / 3);
      slonce.Draw(canvas);
      canvas.FillRectangle(new SolidBrush(Color.FromArgb(255, sky,sky, sky)), 0, (this.ClientSize.Height / 3), this.ClientSize.Width, this.ClientSize.Height - (this.ClientSize.Height) / 3);

		Choinka choinka = new Choinka();
		choinka.Draw(canvas);
		Balwan balwan = new Balwan();
		balwan.Draw(canvas);
		Snieg snieg = new Snieg(1500);
		snieg.Draw(canvas);
	}
      
      private void backgroundWorker_DoWork(object sender, DoWorkEventArgs e) {

      while (1 == 1) {
         if (backgroundWorker.CancellationPending) {
            e.Cancel = true;
            return;
         }
         Draw();
        this.BeginInvoke(new InvokeRefreshDelegate(InvokeRefresh));
        Thread.Sleep(200); 
      }
   }
   
   }

   public class Choinka {

      private static int height = 150;
      private static int width;
      private static int x = 0;
      private static int y = 0;
      private static Color colorG;
      private static Color colorP;

      private Color[] colors = new Color[] { Color.Brown, Color.Chocolate, Color.BurlyWood, Color.Maroon };
      private static Random rnd;

      public Color Pien { get { return colorP; } }
      public Color Galaz { get { return colorG; } }
      public int Height { get { return height; } }
      public int Width { get { return width; } }
      public int X { get { return x; } }
      public int Y { get { return y; } }

      public Choinka() {

         rnd = new Random();

         if (height >= 400) {
            height = rnd.Next(200, 301);
            colorG = Color.FromArgb(0, rnd.Next(64, 256), 0);
            colorP = colors[rnd.Next(0, colors.Length)];
            x = rnd.Next(200, 351);
            y = rnd.Next(100, 401);
         }

         width = (int)(height * 0.15);

         if (x == 0) {
            x = rnd.Next(200, 351);
            y = rnd.Next(100, 401);
            colorG = Color.FromArgb(0, rnd.Next(32, 256), 0);
            colorP = colors[rnd.Next(0, colors.Length)];
         }

         height += 5;
         y -= 5;
         x -= 5;

      }

      public void Draw(Graphics canvas) {

         LinearGradientBrush lgBrush;
         lgBrush = new LinearGradientBrush(new Rectangle(X, Y + (int)(Height * 4 / 5), Width, (int)(Height / 5)), Pien, Color.Black, LinearGradientMode.Horizontal);
         
         canvas.DrawRectangle(new Pen(Color.Black), X, Y + (int)(Height * 4 / 5), Width, (int)(Height / 5));
         canvas.FillRectangle(lgBrush, X, Y + (int)(Height * 4 / 5), Width, (int)(Height / 5));

         GraphicsPath path = new GraphicsPath();
         path.AddPie(X + (int)(Width / 2) - (int)(Height / 2), Y - (int)(Height / 9), (int)(Height), (int)(Height), 45, 90);
         PathGradientBrush pthGrBrush = new PathGradientBrush(path);
         
         pthGrBrush.CenterColor = Galaz;
         Color[] colors = { Color.LightGreen };
         pthGrBrush.SurroundColors = colors;
         canvas.FillPie(pthGrBrush, X + (int)(Width / 2) - (int)(Height / 2), Y - (int)(Height / 9), (int)(Height), (int)(Height), 45, 90);
         path.Dispose();

         path = new GraphicsPath();
         path.AddPie(X + (int)(Width / 2) - (int)(Height * 3 / 8), Y - (int)(Height / 4), (int)(Height * 0.75), (int)(Height * 0.75), 45, 90);
         pthGrBrush = new PathGradientBrush(path);
         
         pthGrBrush.CenterColor = Galaz;

         pthGrBrush.SurroundColors = colors;
         canvas.FillPie(pthGrBrush, X + (int)(Width / 2) - (int)(Height * 3 / 8), Y - (int)(Height / 4), (int)(Height * 0.75), (int)(Height * 0.75), 45, 90);
         path.Dispose();

         path = new GraphicsPath();
         path.AddPie(X + (int)(Width / 2) - (int)(Height / 4), Y - (int)(Height / 3), (int)(Height / 2), (int)(Height / 2), 45, 90);
         pthGrBrush = new PathGradientBrush(path);
         
         pthGrBrush.CenterColor = Galaz;

         pthGrBrush.SurroundColors = colors;
         canvas.FillPie(pthGrBrush, X + (int)(Width / 2) - (int)(Height / 4), Y - (int)(Height / 3), (int)(Height / 2), (int)(Height / 2), 45, 90);
         path.Dispose();
      }
   }

   public class Snieg {

      private static int height = 5;
      private static int width;
      private int[] x;
      private int[] y;
      private string[] p;
      private int _limit;

      private string[] platki = new string[] { "{","z","v","m","R","T","X" };

      public int[] X { get { return this.x; } }
      public int[] Y { get { return this.y; } }
      public string[] P { get { return this.p; } }
      private static Random rnd;

      public Snieg(int limit) {
         rnd = new Random();

         if (height == 10)
            height = rnd.Next(5, 7);

         width = height;
         this._limit = limit;

         x = new int[limit];
         y = new int[limit];
         p = new string[limit];

         for (int i = 0; i < limit; i++) {
            this.x[i] = rnd.Next(0, 1025);
            this.y[i] = rnd.Next(0, 769);
            this.p[i] = platki[rnd.Next(0, platki.Length)];
         }
         height += 1;
      }

      public void Draw(Graphics canvas) {

         for (int i = 0; i < _limit; i++)
            canvas.DrawString(p[i], new Font("Wingdings", height), new SolidBrush(Color.FromArgb(height * 12, height * 10, height * 10, height * 10)), X[i], Y[i]);

      }

   }

   public class Slonce {

      private static int radius = 100;
      private static int x = 200;
      private static int y = 175;
      private static bool zawroc = false;
      public int Y { get { return y; } }

      public void Draw(Graphics canvas) {

         int sun = 255 - (int)(this.Y * 9) / 10;
         GraphicsPath path = new GraphicsPath();
         path.AddEllipse(x, y, radius, radius);
         PathGradientBrush pthGrBrush = new PathGradientBrush(path);
         pthGrBrush.CenterPoint = new PointF(x + 5, y + 5);
         pthGrBrush.CenterColor = Color.LightGoldenrodYellow;
         Color[] colors = { Color.FromArgb(255, 255, sun, 0) };
         pthGrBrush.SurroundColors = colors;
         canvas.FillEllipse(pthGrBrush,x, y, radius, radius);

         x += 6;
         
         if (zawroc == false)
         y -= 2;
         else
         y += 2;

         if (x >= 800) {
            x = 200;
            y = 175;
            zawroc = false;
         }

         if (y <= 75)
            zawroc = true;
      }

   }
   
   public class Balwan {

      private static int height = 60;
      private static int width;
      private static int x = 0;
      private static int y;

      public int X { get { return x; } }
      public int Y { get { return y; } }
      public int Height { get { return height; } }
      public int Width { get { return width; } }
      private static Random rnd;

      public Balwan() {
         rnd = new Random();

         if (height >= 150) {

            height = rnd.Next(60, 81);
            x = rnd.Next(500, 750);
            y = rnd.Next(400, 600);

         }

         width = (int)(height * 1.25);

         if (x == 0) {
            x = rnd.Next(500, 750);
            y = rnd.Next(400, 600);
         }

         height += 2;
         x += 1;
         y -= 1;

      }

      public void Draw(Graphics canvas) {

         int buttonSize = 10;
         int radius = (int)(Width / 2);

         canvas.DrawEllipse(new Pen(Color.Silver), X, Y, Width, Height);
         
         GraphicsPath path = new GraphicsPath();
         path.AddEllipse(X, Y, Width, Height);
         PathGradientBrush pthGrBrush = new PathGradientBrush(path);
         pthGrBrush.CenterPoint = new PointF(X + 5, Y + 5);
         pthGrBrush.CenterColor = Color.White;
         Color[] colors = { Color.Silver };
         pthGrBrush.SurroundColors = colors;
         canvas.FillEllipse(pthGrBrush, X, Y, Width, Height);

         path.Dispose();

         canvas.FillEllipse(new SolidBrush(Color.Black), X + radius - buttonSize / 2, Y + radius - buttonSize, buttonSize, buttonSize);

         int newradius = (int)(radius * 0.75);
         int shiftX = radius - newradius;

         path = new GraphicsPath();
         path.AddEllipse(X + shiftX, Y - (2 * newradius) + 1, newradius * 2, newradius * 2);
         pthGrBrush = new PathGradientBrush(path);
         pthGrBrush.CenterPoint = new PointF(X + shiftX + 5, Y - (2 * newradius) + 5);
         pthGrBrush.CenterColor = Color.White;
         pthGrBrush.SurroundColors = colors;
         canvas.FillEllipse(pthGrBrush, X + shiftX, Y - (2 * newradius) + 1, newradius * 2, newradius * 2);

         path.Dispose();

         canvas.FillEllipse(new SolidBrush(Color.Black), X + shiftX + newradius - buttonSize / 2, Y - (2 * newradius) + newradius - buttonSize / 2, buttonSize, buttonSize);

         radius = newradius;
         newradius = (int)(newradius * 0.75);
         shiftX += (radius - newradius);

         path = new GraphicsPath();
         path.AddEllipse(X + shiftX, Y - (2 * radius) - (2 * newradius) + 2, newradius * 2, newradius * 2);
         pthGrBrush = new PathGradientBrush(path);
         pthGrBrush.CenterPoint = new PointF(X + shiftX + 5, Y - (2 * newradius) + 5);
         pthGrBrush.CenterColor = Color.White;
         pthGrBrush.SurroundColors = colors;
         canvas.FillEllipse(pthGrBrush, X + shiftX, Y - (2 * radius) - (2 * newradius) + 2, newradius * 2, newradius * 2);

         path.Dispose();

         canvas.FillEllipse(new SolidBrush(Color.Black), X + shiftX + (int)(newradius / 2) - buttonSize / 2, Y - (2 * radius) - (2 * newradius) + newradius - buttonSize / 2, buttonSize, buttonSize);
         canvas.FillEllipse(new SolidBrush(Color.Black), X + shiftX + (int)(newradius * 3 / 2) - buttonSize / 2, Y - (2 * radius) - (2 * newradius) + newradius - buttonSize / 2, buttonSize, buttonSize);

      }
   }

}
