﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Obrazy
{
    public partial class Form1 : Form
    {
        string sciezkaPliku = "";
        Random rd = new Random();
        enum edycja
        {
            BW,
            BWAVER,
            BWLUMA,
            INVERT,
            BRIGHT,
            CONTRAST,
            R,
            G,
            B

        }
        Bitmap oryginal, staryoryginal;
        public Form1()
        {
            InitializeComponent();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = sciezkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    pictureBox1.Image = Image.FromFile(openFileDialog1.FileName);
                    sciezkaPliku = openFileDialog1.FileName;
                    oryginal = new Bitmap(pictureBox1.Image);
                    zapiszToolStripMenuItem.Enabled = true;
                    //Width = pictureBox1.Image.Width;
                    //Height = pictureBox1.Image.Height+menuStrip1.Height;
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku" + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }

           

        }

        /*private void czarnobiałyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            //mega wolne GetPixel i SetPixel
            for (int x=0; x < obraz.Width; x++)
            {
                for (int y = 0; y < obraz.Height; y++)
                {
                    Color kolorPiksela=obraz.GetPixel(x, y);
                    int kolor = (int)(kolorPiksela.R * 0.21 + kolorPiksela.G * 0.72 + kolorPiksela.B * 0.07);
                    obraz.SetPixel(x, y, Color.FromArgb(kolor, kolor, kolor));
                }

            }
            pictureBox1.Image = obraz;
           

        }*/

        private void Form1_Load(object sender, EventArgs e)
        {
            pictureBox1.SizeMode = PictureBoxSizeMode.AutoSize;
            trbContrast_ValueChanged(null, null);
            trbBrightness_ValueChanged(null, null);
            zapiszToolStripMenuItem.Enabled = false;
        }

        private void negatywToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Edycja(edycja.INVERT);
            ZapiszPoprzedniObraz();
        }

        private void Edycja(edycja ed)
        {
            //obraz = new Bitmap(pictureBox1.Image);
            if (oryginal != null)
            {
                Bitmap obraz = oryginal.Clone(new Rectangle(0, 0, oryginal.Width, oryginal.Height), PixelFormat.Format24bppRgb);

                int krok = Bitmap.GetPixelFormatSize(obraz.PixelFormat);
                if (krok != 24 && krok != 32)  //w sumie niepotrzebne
                {
                    MessageBox.Show("Możliwe tylko dla obrazów 24 i 32 bitowych!", "Błąd", MessageBoxButtons.OK);
                    return;
                }
                krok = krok / 8;
                BitmapData bd = obraz.LockBits(new Rectangle(0, 0, pictureBox1.Image.Width, pictureBox1.Image.Height), ImageLockMode.ReadWrite, obraz.PixelFormat);

                int rozmiar = bd.Width * bd.Height * krok;
                byte[] dane = new byte[rozmiar];


                System.Runtime.InteropServices.Marshal.Copy(bd.Scan0, dane, 0, rozmiar);
                int bright = trbBrightness.Value;    //wyjątkowo powolna metoda
                int contrast = trbContrast.Value;
                int r = trbR.Value;
                int g = trbG.Value;
                int b = trbB.Value;
                for (int i = 0; i < rozmiar; i += krok)
                {
                    switch (ed)
                    {
                        case edycja.BWAVER:
                            byte kolor = (byte)((dane[i] + dane[i + 1] + dane[i + 2]) / 3);
                            dane[i] = dane[i + 1] = dane[i + 2] = kolor;
                            break;
                        case edycja.BWLUMA:
                            kolor = (byte)(dane[i] * 0.11 + dane[i + 1] * 0.59 + dane[i + 2] * 0.3);
                            dane[i] = dane[i + 1] = dane[i + 2] = kolor;
                            break;
                        case edycja.INVERT:
                            dane[i] = (byte)(255 - dane[i]);
                            i += 1 - krok;
                            break;
                        case edycja.BW:
                            kolor = (byte)((dane[i] + dane[i + 1] + dane[i + 2]) / 3);
                            dane[i] = dane[i + 1] = dane[i + 2] = (byte)(((kolor + rd.Next(40) - 20) / 128) * 255);  //nie rozumiem dlaczego to rzutowanie działa
                            break;
                        case edycja.BRIGHT:
                            dane[i] = DodajDo255(dane[i], bright);
                            i += 1 - krok;
                            break;
                        case edycja.CONTRAST:
                            double kontrast = dane[i] * contrast/128;
                            if (kontrast > 255) kontrast = 255;
                            if (kontrast < 0) kontrast = 0;
                            dane[i] = (byte)kontrast;
                            i += 1 - krok;
                            break;
                        case edycja.R:
                            dane[i + 2] = DodajDo255(dane[i + 2],r);
                            break;
                        case edycja.G:
                            dane[i + 1] = DodajDo255(dane[i + 1], g);
                            break;
                        case edycja.B:
                            dane[i] = DodajDo255(dane[i], b);
                            break;
                    }

                }

                System.Runtime.InteropServices.Marshal.Copy(dane, 0, bd.Scan0, dane.Length);
                obraz.UnlockBits(bd);
                pictureBox1.Image = obraz;
            }
        }

        private byte DodajDo255(byte skladowaPiksela, int dodaj)
        {
            int temp = skladowaPiksela + dodaj;
            if (temp > 255)
                return 255;
            else if (temp < 0)
                return 0;
            return (byte)temp;
        }

        private void lumaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Edycja(edycja.BWLUMA);
            ZapiszPoprzedniObraz();

        }

        private void ZapiszPoprzedniObraz()
        {
            staryoryginal = new Bitmap(oryginal);
            oryginal = new Bitmap(pictureBox1.Image);
        }

        private void średniaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Edycja(edycja.BWAVER);
            ZapiszPoprzedniObraz();

        }

        private void czarnobiałoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Edycja(edycja.BW);
            ZapiszPoprzedniObraz();
        }

        private void panelBocznyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            panel2.Visible = panelBocznyToolStripMenuItem.Checked;
            if (panel2.Visible) pictureBox1.Left = panel2.Width;
            else
                pictureBox1.Left = 0;
            btnReset_Click(null, null);
        }


        private void btnReset_Click(object sender, EventArgs e)
        {
            trbBrightness.Value = trbR.Value = trbG.Value = trbB.Value = 0;
            trbContrast.Value = 128;
            btnPreview_Click(null, null);
        }

        private void btnWykonaj_Click(object sender, EventArgs e)
        {
            ZapiszPoprzedniObraz();
            btnReset_Click(sender, e);
        }


        private void btnPreview_Click(object sender, EventArgs e)
        {
            if (oryginal != null)
            {
                Bitmap temp = new Bitmap(oryginal);
                Edycja(edycja.CONTRAST);
                oryginal = (Bitmap)pictureBox1.Image;
                Edycja(edycja.BRIGHT);
                oryginal = (Bitmap)pictureBox1.Image;
                Edycja(edycja.R);
                oryginal = (Bitmap)pictureBox1.Image;
                Edycja(edycja.G);
                oryginal = (Bitmap)pictureBox1.Image;
                Edycja(edycja.B);
                oryginal = temp;
            }
        }




        private void trbBrightness_MouseUp(object sender, MouseEventArgs e)
        {
            if (chkLive.Checked)
            {
                btnPreview_Click(null, null);
            }
        }

        private void trbBrightness_KeyUp(object sender, KeyEventArgs e)
        {
            trbBrightness_MouseUp(null, null);

        }

        private void trbBrightness_ValueChanged(object sender, EventArgs e)
        {
            labBright.Text = "Jasność " + trbBrightness.Value;
        }

        private void trbContrast_ValueChanged(object sender, EventArgs e)
        {
            labContrast.Text = "Kontrast " + (trbContrast.Value-128);
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (saveFileDialog1.ShowDialog() == DialogResult.OK && oryginal != null)
                {
                    sciezkaPliku = saveFileDialog1.FileName;
                    string ext=Path.GetExtension(sciezkaPliku);
                    pictureBox1.Image.Save(sciezkaPliku, Rozszerzenie(ext));
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd zapisu pliku" + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Undo();
        }

        private void Undo()
        {
            if (oryginal != null && staryoryginal != null)
            {
                oryginal = new Bitmap(staryoryginal);
                pictureBox1.Image = oryginal;
            }
        }

        private void trbR_ValueChanged(object sender, EventArgs e)
        {
            labR.Text = "R " + trbR.Value;
        }

        private void trbG_ValueChanged(object sender, EventArgs e)
        {
            labG.Text = "G " + trbG.Value;
        }

        private void trbB_ValueChanged(object sender, EventArgs e)
        {
            labB.Text = "B " + trbB.Value;
        }

        private ImageFormat Rozszerzenie(string ext)
        {
            switch (ext)
            {
                case ".bmp":
                    return ImageFormat.Bmp;
                case ".png":
                    return ImageFormat.Png;
            }
            return ImageFormat.Jpeg;
        }
    }
}
