using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Studium_1
{
    public partial class frm : Form
    {
        private string ofdLastFile = string.Empty;
        private bool teksZmieniony = true;
        private StringBuilder sb = new StringBuilder();

        public frm()
        {
            InitializeComponent();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                ofd.FileName = ofdLastFile;
                if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    ofdLastFile = ofd.FileName;
                    tb.ReadOnly = ofd.ReadOnlyChecked;
                    tb.Lines = File.ReadAllLines(ofd.FileName);
                    teksZmieniony = false;
                    ustalTytulOkna();
                    if (Path.GetExtension(ofdLastFile).Equals("cs"))
                        doCSharp();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd odczytu: " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void doCSharp()
        {
            rtb.Text = sb.Append(tb.Lines).ToString();
        }

        private string ustalTytulOkna()
        {
            return this.Text = Path.GetFileName(ofdLastFile) + (teksZmieniony ? "*" : "") + " - Notatnik";
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszPlik(sender, e);
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                cd.Color = tb.BackColor;
                cd.AllowFullOpen = true;
                if (cd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.BackColor = cd.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd : " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                fd.Font = tb.Font;
                fd.Color = tb.ForeColor;
                if (fd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.Font = fd.Font;
                    tb.ForeColor = fd.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd : " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszPlik(sender, e);
        }

        private void zapiszPlik(object sender, EventArgs e)
        {
            try
            {
                teksZmieniony = false;
                if (!File.Exists(ofdLastFile))
                    zapiszJakoDoPliku(sender, e);
                else
                    File.WriteAllLines(ofdLastFile, tb.Lines);
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error
                    );
            }
        }

        private void zapiszJakoDoPliku(object sender, EventArgs e)
        {
            try
            {
                sfd.InitialDirectory = Path.GetDirectoryName(ofd.FileName);
                sfd.FileName = Path.GetFileName(ofdLastFile);
                if (sfd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.ReadOnly = false;
                    ofdLastFile = sfd.FileName;
                    File.WriteAllLines(sfd.FileName, tb.Lines);
                    ustalTytulOkna();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd zapisu: " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!teksZmieniony)
                wyczyscNotatnik();
            else
            {
                DialogResult dr = MessageBox.Show("Czy chcesz zapisać zmiany w pliku  " + ofdLastFile + "?", this.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                switch (dr)
                {
                    case DialogResult.Yes:
                        zapiszJakoDoPliku(null, null);
                        wyczyscNotatnik();

                        break;
                    case DialogResult.No:
                        wyczyscNotatnik();
                        break;
                    case DialogResult.Cancel:
                        break;
                }
            }
        }

        private void wyczyscNotatnik()
        {
            tb.Text = "";
            ofdLastFile = "";
            teksZmieniony = false;
            ustalTytulOkna();
        }
    }
}
