﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        string ścieżkaPliku = "";
        bool tekstZmieniony = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void wczytajZPliku(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = ścieżkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    textBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    ścieżkaPliku = openFileDialog1.FileName;                    
                    tekstZmieniony = false;
                    ustalTytułOkna();
                }
            }
            catch(Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void ustalTytułOkna()
        {
            this.Text = 
                Path.GetFileName(ścieżkaPliku) + 
                (tekstZmieniony?"*":"") + 
                " - Notatnik.NET";
        }

        private void zapiszDoPliku(object sender, EventArgs e)
        {
            //zawartość przeniesiona do osobnej metody
            _zapiszDoPliku();
        }

        private bool _zapiszDoPliku()
        {
            //if (!string.IsNullOrWhiteSpace(ścieżkaPliku))
            if (File.Exists(ścieżkaPliku))
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            else
            {
                saveFileDialog1.FileName = "";
            }
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.ReadOnly = false;
                File.WriteAllLines(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
                tekstZmieniony = false;
                ustalTytułOkna();
                return true;
            }
            else return false;
        }

        private void zmieńKolorTła(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void zmnieńCzcionkę(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void przełączZawijanieWierszy(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszDoPlikuBezOknaDialogowe(object sender, EventArgs e)
        {
            _zapiszDoPlikuBezOknaDialogowego();
        }

        private bool _zapiszDoPlikuBezOknaDialogowego()
        {
            try
            {
                if (!File.Exists(ścieżkaPliku)) return _zapiszDoPliku();
                else
                {
                    File.WriteAllLines(ścieżkaPliku, textBox1.Lines);
                    tekstZmieniony = false;
                    ustalTytułOkna();
                    return true;
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) wyczyśćNotatnik();
            else if (spytajCzyZapisać()) wyczyśćNotatnik();
        }

        private bool spytajCzyZapisać()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku " + ścieżkaPliku + "?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);
            switch (dr)
            {
                case DialogResult.Yes:
                    return _zapiszDoPlikuBezOknaDialogowego();                    
                case DialogResult.No:
                    return true;                    
                case DialogResult.Cancel:
                    return false;                    
                default:
                    throw new Exception("Nieprzewidziana wartość zmiennej 'dr'");
            }
        }

        private void wyczyśćNotatnik()
        {
            textBox1.Text = "";
            ścieżkaPliku = "";
            tekstZmieniony = false;
            ustalTytułOkna();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            tekstZmieniony = true;
            ustalTytułOkna();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) Close();
            else if (spytajCzyZapisać()) Close();            
        }        
    }
}
