﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DragAndDrop
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            for (int i = 1; i <= 10; ++i)
            {
                listBox1.Items.Add("Element " + i.ToString() + " z listy 1");
                listBox2.Items.Add("Element " + i.ToString() + " z listy 2");
            }
        }

        ListBox lbSource = null;

        private void listBox1_MouseDown(object sender, MouseEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            if(e.Button == MouseButtons.Left && lbSender.SelectedIndex != -1)
            {
                lbSource = lbSender;
                lbSender.DoDragDrop(
                    lbSender.SelectedItem, 
                    DragDropEffects.Copy | DragDropEffects.Move);
            }
        }

        private void listBox2_DragOver(object sender, DragEventArgs e)
        {
            if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move)
            {
                if((e.KeyState & 8) == 8)
                    e.Effect = DragDropEffects.Copy;
                else e.Effect = DragDropEffects.Move;
            }
        }

        private void listBox2_DragDrop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            Point p = lbSender.PointToClient(new Point(e.X, e.Y));
            int index = lbSender.IndexFromPoint(p);
            if (index < 0) lbSender.Items.Add(lbSource.SelectedItem);  
            else lbSender.Items.Insert(index, lbSource.SelectedItem);
            if(e.Effect == DragDropEffects.Move)
                lbSource.Items.Remove(lbSource.SelectedItem);
        }
    }
}
