﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;
using System.Windows.Media;

namespace PasekPostępu
{
    public class WyłączanieKontrolki : Behavior<UIElement>
    {
        public WyłączanieKontrolki()
        {
            Klawisz = Key.E;
        }

        public Key Klawisz { get; set; } //= Key.E;

        protected override void OnAttached()
        {
            UIElement e = this.AssociatedObject;
            //if (e != null) e.IsEnabled = false;
            if (e != null) e.KeyDown += e_KeyDown;
        }

        void e_KeyDown(object sender, System.Windows.Input.KeyEventArgs e)
        {
            if(e.Key == Klawisz)
                (sender as UIElement).IsEnabled = false;
        }
    }

    public class ZmianaPozycjiSuwaka : Behavior<Slider>
    {
        protected override void OnAttached()
        {
            Slider slider = this.AssociatedObject;
            slider.KeyDown += Slider_KeyDown;
        }

        void Slider_KeyDown(object sender, KeyEventArgs e)
        {

            Slider slider = sender as Slider;
            if (e.Key >= Key.D0 && e.Key <= Key.D9)
            {
                int wsp = ((int)e.Key - (int)Key.D0);
                if (wsp == 0) slider.Value = slider.Maximum;
                else slider.Value = slider.Minimum + wsp * (slider.Maximum - slider.Minimum) / 10.0;
            }
            if (e.Key == Key.OemTilde) slider.Value = slider.Minimum;
        }
    }

    public class KolorNapisu : Behavior<TextBlock>
    {
        public static readonly DependencyProperty KolorCzcionkiProperty =
            DependencyProperty.Register(
                "KolorCzcionki", typeof(Color), typeof(KolorNapisu),
                new PropertyMetadata(Brushes.Transparent, KolorZmieniony));

        public Color KolorCzcionki
        {
            get { return (Color)GetValue(KolorCzcionkiProperty); }
            set { SetValue(KolorCzcionkiProperty, value); }
        }

        private static void KolorZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            KolorNapisu instancja = d as KolorNapisu;
            TextBlock napis = instancja.AssociatedObject;
            if (napis != null) napis.Foreground = new SolidColorBrush(instancja.KolorCzcionki);
        }
    }
}
