﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kolekcje.Model
{
    public enum PriorytetZadania { MniejWażne, Ważne, Krytyczne };

    public class Zadanie
    {
        public string Opis { get; private set; }
        public DateTime DataUtworzenia { get; private set; }
        public DateTime PlanowanyTerminRealizacji { get; private set; }
        public PriorytetZadania Priorytet { get; private set; }
        public bool CzyZrealizowane { get; private set; }
        
        public Zadanie(
            string opis, DateTime dataUtworzenia, 
            DateTime planowanyTerminRealizacji, PriorytetZadania priorytet,
            bool czyZrealizowane = false)
        {
            Opis = opis;
            DataUtworzenia = dataUtworzenia;
            PlanowanyTerminRealizacji = planowanyTerminRealizacji;
            Priorytet = priorytet;
            CzyZrealizowane = czyZrealizowane;
        }

        public override string ToString()
        {
            return Opis;
        }
    }
}
