﻿using System;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Windows.Input;

using MVVMUtils;
using System.Windows;

namespace Kolekcje.ModelWidoku
{
    public class Zadania
    {
        private const string ścieżkaPlikuXml = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; private set; }

        private void kopiujZadaniaZModelu() //z modelu do kolekcji obserwowalnej
        {
            ListaZadań.CollectionChanged -= SynchronizacjaZadań;
            ListaZadań.Clear();
            foreach (Model.Zadanie zadanie in model)
                ListaZadań.Add(new Zadanie(zadanie));
            ListaZadań.CollectionChanged += SynchronizacjaZadań;
        }

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPlikuXml))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXml);
            else model = new Model.Zadania();

            //model.DodajZadanie(new Model.Zadanie("Coś1", DateTime.Now.AddDays(-1), DateTime.Now.AddDays(3), Model.PriorytetZadania.Ważne));
            //model.DodajZadanie(new Model.Zadanie("Coś2", DateTime.Now, DateTime.Now.AddDays(2), Model.PriorytetZadania.Krytyczne));
            //model.DodajZadanie(new Model.Zadanie("Coś3", DateTime.Now, DateTime.Now.AddDays(1), Model.PriorytetZadania.MniejWażne));

            ListaZadań = new ObservableCollection<Zadanie>();
            kopiujZadaniaZModelu();
        }

        private void SynchronizacjaZadań(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch(e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    {
                        Zadanie zadanie = (Zadanie)e.NewItems[0];
                        if (zadanie != null) model.DodajZadanie(zadanie.GetModel());
                    }
                    break;
                case NotifyCollectionChangedAction.Remove:
                    {
                        Zadanie zadanie = (Zadanie)e.OldItems[0];
                        if (zadanie != null) model.UsuńZadanie(zadanie.GetModel());
                    }
                    break;
            }
        }

        private ICommand zapisz;

        public ICommand Zapisz
        {
            get
            {
                if (zapisz == null)
                    zapisz = new RelayCommand(o => { Model.PlikXML.Zapisz(ścieżkaPlikuXml, model); }, o => true);
                return zapisz;
            }
        }

        private ICommand usuńZadanie;

        public ICommand UsuńZadanie
        {
            get
            {
                if (usuńZadanie == null)
                    usuńZadanie = new RelayCommand(
                        o =>
                        {
                            int indeksZadania = (int)o;
                            Zadanie zadanie = ListaZadań[indeksZadania];
                            if (!zadanie.CzyZrealizowane)
                            {
                                MessageBoxResult mbr = MessageBox.Show("Czy jesteś pewien, że chcesz usunąć niezrealizowane zadanie?", "Zadania WPF", MessageBoxButton.YesNo, MessageBoxImage.Question, MessageBoxResult.No);
                                if (mbr == MessageBoxResult.No) return;
                            }
                            ListaZadań.Remove(zadanie);
                        });
                    return usuńZadanie;
            }
        }
    }
}
