﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using generowanieKolorow;

namespace Kolory
{
    public partial class Form1 : Form
    {
        // kontener do przetrzymywania kolorów
        List<Button> pallete = new List<Button>();
        HSLColorPallete HSLpaleta;
        private uint currentSelect = 0;

        // pola opisujące paletę
        private const int palleteSizeX = 7;
        private const int palleteSizeY = 4;
        private const int X0 = 182;
        private const int Y0 = 165;
        private int licznik = 0;

        // import FUNKCJI z bibliotek windows
        [DllImport("user32.dll")]
        static extern bool GetCursorPos(ref Point lpPoint);
        [DllImport("gdi32.dll", CharSet = CharSet.Auto, SetLastError = true, ExactSpelling = true)]
        public static extern int BitBlt(IntPtr hDC, int x, int y, int nWidth, int nHeight, IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        // pole na potrzeby funkci getColor (pojedynczy pixel)
        private Bitmap screenPixel = new Bitmap(1, 1, PixelFormat.Format32bppArgb);

        ///////////////////// -- METODY -- //////////////////////////

        /// <summary>
        /// Konstruktor inicjalizujący formę w komponenty oraz ich zawartość
        /// </summary>
        public Form1()
        {
            InitializeComponent();

            //SetStyle(ControlStyles.UserPaint, true);
            //SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            //SetStyle(ControlStyles.DoubleBuffer, true);

            SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            SetStyle(ControlStyles.ResizeRedraw, false);
            SetStyle(ControlStyles.UserPaint, true);
            SetStyle(ControlStyles.SupportsTransparentBackColor, false);

            DoubleBuffered = true;
            UpdateStyles();

            // wczytuje położenie suwaka definiującego paletę
            //trackBar4.Value = Properties.Settings.Default.p_val;

            // tworzymy tęczę na picturebox
            //trackBar4_Scroll(null, null);

            // wczytaj polożenie suwaków
            trackBar1.Value = Properties.Settings.Default.r;
            trackBar2.Value = Properties.Settings.Default.g;
            trackBar3.Value = Properties.Settings.Default.b;
            textBox4.Text = trackBar1.Value.ToString();
            textBox5.Text = trackBar2.Value.ToString();
            textBox6.Text = trackBar3.Value.ToString();


            // wczytaj położenie i rozmiar okna
            this.Top = Properties.Settings.Default.top;
            this.Left = Properties.Settings.Default.left;
            this.Width = Properties.Settings.Default.w;
            this.Height = Properties.Settings.Default.h;

            // update komponentów na podstawie wartości scroli
            changeColorViaScrol(null, null);

            // tworzymy palete barw przechowyjącą ulubione kolory
            for (int i = 0; i < palleteSizeY; i++)
            {
                for (int j = 0; j < palleteSizeX; j++)
                {
                    dodajButton(X0 + j * 30, Y0 + i * 30, 30, 30, Color.White);
                }
            }

            // wcczytujemy kolory do palety barw z ulubionymi kolorami
            try
            {
                //Properties.Settings.Default.Pallete.Clear();
                for (int i = 0; i < Properties.Settings.Default.Pallete.Count; i++)
                {
                    pallete[i].BackColor = Color.FromArgb(
                        255,
                         byte.Parse(Properties.Settings.Default.Pallete[i].Substring(0, 3)),
                         byte.Parse(Properties.Settings.Default.Pallete[i].Substring(4, 3)),
                         byte.Parse(Properties.Settings.Default.Pallete[i].Substring(8, 3))
                         );
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }

            HSLpaleta = new HSLColorPallete(pictureBox1.Width / 2, 1);
            pictureBox1.Image = HSLpaleta.b;
        }

        /// <summary>
        /// Po zamknieciu formy zachowywane są dane.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="f"></param>
        private void Form1_FormClosed(object sender, FormClosedEventArgs f)
        {
            // zapisywanie ostatniego aktywnego koloru 
            Properties.Settings.Default.r = (byte)trackBar1.Value;
            Properties.Settings.Default.g = (byte)trackBar2.Value;
            Properties.Settings.Default.b = (byte)trackBar3.Value;

            // zapamiętywanie pozycji i rozmiaru okna
            Properties.Settings.Default.w = this.Width;
            Properties.Settings.Default.h = this.Height;
            Properties.Settings.Default.top = this.Top;
            Properties.Settings.Default.left = this.Left;

            // zapisuję polożenie suwaka palety
            //Properties.Settings.Default.p_val = (byte)this.trackBar4.Value;

            // zapisuje paletę barw
            if (Properties.Settings.Default.Pallete.Count > 0)
            {
                // gdy już istnieją wpisy xml - nadpisuję
                for (int i = 0; i < pallete.Count; i++)
                {
                    Properties.Settings.Default.Pallete[i] =
                        pallete[i].BackColor.R.ToString().PadLeft(3, '0') + "," +
                        pallete[i].BackColor.G.ToString().PadLeft(3, '0') + "," +
                        pallete[i].BackColor.B.ToString().PadLeft(3, '0');
                }
            }
            else
            {
                // gdy ich jeszcze nie ma - tworzę nowe obiekty
                for (int i = 0; i < pallete.Count; i++)
                {
                    Properties.Settings.Default.Pallete.Add(
                        pallete[i].BackColor.R.ToString().PadLeft(3, '0') + "," +
                        pallete[i].BackColor.G.ToString().PadLeft(3, '0') + "," +
                        pallete[i].BackColor.B.ToString().PadLeft(3, '0')
                        );
                }
            }

            // zapisywanie ustawień do xml systemowego
            Properties.Settings.Default.Save();
        }

        /// <summary>
        /// Metoda powoduje dodanie koloru na początku kolejki.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void zapiszWPalecie_Click(object sender, EventArgs e)
        {
            // przesuwanie kolorów w prawo w liście (utrata ostatniego elementu)
            for (int i = pallete.Count - 2; i >= 0; i--)
            {
                pallete[i + 1].BackColor = pallete[i].BackColor;
            }
            // zapisywanie w pierszej kontrolce aktualnego koloru
            pallete[0].BackColor = panel1.BackColor;
        }

        /// <summary>
        /// Uruchomienie zczytywania koloru, przez uruchomienie zegara.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void UruchomZczytywanie_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Najedź na dowolne miejsce na ekranie, a następnie naciśnij Ctrl+D, aby zapisać kolor! Aby Ctrl+D zadziałało aplikacja musi mieć aktywne okno.", "Wybieranie koloru", MessageBoxButtons.OK, MessageBoxIcon.Information);
            //this.TopMost = true;
            timer1.Enabled = true;
            //this.Cursor = Cursors.Cross;        
        }

        /// <summary>
        /// Zdarzenie kontrolki timer1 aktualizujące bieżące parametry koloru spod kursora z dowolnego punktu ekranu. Zdarzenie przesyła te parametry do wybranych kontrolek przez wywołanie zdarzenia changeColorViaScroll. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            Point p = new Point();
            Color c = new Color();

            // przesyłamy punkt przez referencję 
            GetCursorPos(ref p);

            c = GetColorAt(p);

            trackBar1.Value = c.R;
            trackBar2.Value = c.G;
            trackBar3.Value = c.B;

            changeColorViaScrol(null, null);
        }

        /// <summary>
        /// Zdarzenie obsługujące kliknięcie na paletę barw.
        /// </summary>
        /// <param name="sender">Referencja obiektu generującego zdarzenie.</param>
        /// <param name="e">Argumenty towaryszące powstaniu zdarzenia (nieużywane).</param>
        private void palete_Click(object sender, EventArgs e)
        {
            // odczytaj kolor z klikniętego pola palety i zapisz do suwaków
            trackBar1.Value = ((Button)sender).BackColor.R;
            trackBar2.Value = ((Button)sender).BackColor.G;
            trackBar3.Value = ((Button)sender).BackColor.B;

            // odśwież kontrolki na formie
            changeColorViaScrol(null, null);

            currentSelect = uint.Parse(((Button)sender).Name);
            //MessageBox.Show("wybrałeś: " + currentSelect.ToString());
        }

        /// <summary>
        /// Wyczyść paletę.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void wyczyscPalete_Click(object sender, EventArgs e)
        {
            foreach (Button b in pallete)
            {
                b.BackColor = Color.White;
            }
        }

        /// <summary>
        /// Zdarzenie które sprawdza czy naciśnięta została kombinacja Ctrl+D
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="keyData"></param>
        /// <returns></returns>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            if (keyData == (Keys.Control | Keys.D))
            {
                timer1.Enabled = false;
                //this.TopMost = false;
                return true;
            }
            return base.ProcessCmdKey(ref msg, keyData);
        }

        /// <summary>
        /// Funkcja dodaje do List0 >Button> kolejne pola palety w sposób dynamiczny.
        /// </summary>
        /// <param name="X">Współrzędna początkowa x-owa pola.</param>
        /// <param name="Y">Współrzędna początkowa y-kowa pola.</param>
        /// <param name="widthB">Szerokość pola.</param>
        /// <param name="heightB">Wysokość pola.</param>
        /// <param name="c">Kolor pola.</param>
        private void dodajButton(int X, int Y, int widthB, int heightB, Color c)
        {
            pallete.Add(new Button());

            pallete[pallete.Count - 1].Location = new System.Drawing.Point(X, Y);
            pallete[pallete.Count - 1].Name = (licznik).ToString();
            pallete[pallete.Count - 1].Size = new System.Drawing.Size(widthB, heightB);
            pallete[pallete.Count - 1].TabIndex = licznik;
            pallete[pallete.Count - 1].Text = "";
            pallete[pallete.Count - 1].ForeColor = c; //InvertMeAColour(c);
            pallete[pallete.Count - 1].UseVisualStyleBackColor = true;
            pallete[pallete.Count - 1].BackColor = c;
            pallete[pallete.Count - 1].Anchor = AnchorStyles.Left | AnchorStyles.Bottom;
            pallete[pallete.Count - 1].Click += new System.EventHandler(palete_Click);/// !!! new jest słowem kluczowym

            licznik += 1;
            this.Controls.Add(pallete[pallete.Count - 1]);
        }

        /// <summary>
        /// Funkcja używająca WINApi do odczytania koloru z określonego punktu.
        /// </summary>
        /// <param name="location">Punkt w którym odczytywany jest kolor</param>
        /// <returns>Odczytany kolor</returns>
        private Color GetColorAt(Point location)
        {
            // gdest - graphic destination
            // gsrc - graphic source

            using (Graphics gdest = Graphics.FromImage(screenPixel)) // tworzymy obiekt klasy Graphics z pixela
            {
                using (Graphics gsrc = Graphics.FromHwnd(IntPtr.Zero)) // tworzymy pusty obiekt klasy Graphics 
                {
                    IntPtr hSrcDC = gsrc.GetHdc(); // wskaznik do grafiki source
                    IntPtr hDC = gdest.GetHdc(); // wsskaznik do grafiki destination

                    /*
                    The BitBlt function performs a bit-block transfer of the color data 
                    corresponding to a rectangle of pixels from the specified source device 
                    context into a destination device context. 
                    */
                    //BitBlt(wskaźnik do pixela, x-wsp, y-wsp, szerokość, wysokość, wsp x pobieranego miejsca, wsp y pob miejsca
                    BitBlt(hDC, 0, 0, 1, 1, hSrcDC, location.X, location.Y, (int)CopyPixelOperation.SourceCopy);

                    // zeruje wkazniki
                    gdest.ReleaseHdc();
                    gsrc.ReleaseHdc();
                }
            }

            // zwracamy odczytany kolor pixela
            return screenPixel.GetPixel(0, 0);
        }

        /// <summary>
        /// Usuwa currentSelect kolor z palety List button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void usunPierwszyKolorPalety_Click(object sender, EventArgs e)
        {
            for (uint i = currentSelect; i < pallete.Count - 1; i++)
            {
                pallete[(int)i].BackColor = pallete[(int)(i + 1)].BackColor;
            }
            currentSelect = 0;
        }

        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            Color c = new Color();

            c = GetColorAt(new Point(Cursor.Position.X, Cursor.Position.Y));

            trackBar1.Value = c.R;
            trackBar2.Value = c.G;
            trackBar3.Value = c.B;

            changeColorViaScrol(null, null);
        }

        /// <summary>
        /// Zdarzenie obsługujące sytuację, gdy coś zmieni położenie suwaków.
        /// </summary>
        /// <param name="sender">Referencja obiektu generującego zdarzenie.</param>
        /// <param name="e">Argumenty towaryszące powstaniu zdarzenia (nieużywane).</param>
        private void changeColorViaScrol(object sender, EventArgs e)
        {
            panel1.BackColor = Color.FromArgb(
                trackBar1.Value,
                trackBar2.Value,
                trackBar3.Value);
            String.Format("{00}", "F");
            //textBox1.Text = "[" + trackBar1.Value + ", " + trackBar2.Value + ", " + trackBar3.Value + "]";
            textBox2.Text = "#" + String.Format("{0:X}", trackBar1.Value).PadLeft(2, '0') + String.Format("{0:X}", trackBar2.Value).PadLeft(2, '0') + String.Format("{0:X}", trackBar3.Value).PadLeft(2, '0');
            textBox3.Text = "[" + Math.Round(panel1.BackColor.GetHue(), 1) + "°, " +
                                  Math.Round(panel1.BackColor.GetSaturation() * 100, 1) + "%, " +
                                  Math.Round(panel1.BackColor.GetBrightness() * 100, 1) + "%]";

            textBox4.Text = trackBar1.Value.ToString();
            textBox5.Text = trackBar2.Value.ToString();
            textBox6.Text = trackBar3.Value.ToString();
        }

        private void WidowsColorDialogButton_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = Color.FromArgb(255, trackBar1.Value, trackBar2.Value, trackBar3.Value);

            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                trackBar1.Value = colorDialog1.Color.R;
                trackBar2.Value = colorDialog1.Color.G;
                trackBar3.Value = colorDialog1.Color.B;

                changeColorViaScrol(null, null);
            }
        }


        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            if (HSLpaleta.isPointInsidePallete(new Point(e.X, e.Y)))
            {
                this.Cursor = Cursors.Cross;
                if (HSLpaleta.mouseDownOverPalete)
                    pictureBox1_MouseClick_1(sender, e);
            }
            else
                this.Cursor = Cursors.Default;

        }

        private void pictureBox1_MouseLeave(object sender, EventArgs e)
        {
            this.Cursor = Cursors.Default;
        }

        private void pictureBox1_MouseClick_1(object sender, MouseEventArgs e)
        {
            if (HSLpaleta.isPointInsidePallete(new Point(e.X, e.Y)))
            {
                Color c = ((Bitmap)((PictureBox)sender).Image).GetPixel(e.X, e.Y);
                trackBar1.Value = c.R;
                trackBar2.Value = c.G;
                trackBar3.Value = c.B;
                changeColorViaScrol(null, null);
            }
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            HSLpaleta.mouseDownOverPalete = true;
        }

        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            HSLpaleta.mouseDownOverPalete = false;
        }

        private void trackBar5_MouseUp(object sender, MouseEventArgs e)
        {
            HSLpaleta = new HSLColorPallete(pictureBox1.Width / 2, ((double)trackBar5.Value) / 100);
            pictureBox1.Image = HSLpaleta.b;
        }

        private void trackBar5_Scroll(object sender, EventArgs e)
        {

            label1.Text = trackBar5.Value.ToString() + "%";

        }
    }
}