﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace generowanieKolorow
{
    class Vector
    {
        Double _x, _y;

        /// <summary>
        /// Object constructor
        /// </summary>
        /// <param name="_x">First component of vector</param>
        /// <param name="_y">Second component of vector</param>
        public Vector(double x, double y)
        {
            _x = x;
            _y = y;
        }

        /// <summary>
        /// Object constructor
        /// </summary>
        /// <param name="a">Start point of vector</param>
        /// <param name="b">End point of vector</param>
        public Vector(Point a, Point b)
        {
            _x = a.X - b.X;
            _y = a.Y - b.Y;
        }
        /// <summary>
        /// Object constructor
        /// </summary>
        /// <param name="x1">X coordinate of start point of vector</param>
        /// <param name="y1">Y coordinate of start point of vector</param>
        /// <param name="x2">X coordinate of end point of vector</param>
        /// <param name="y2">Y coordinate of end point of vector</param>
        public Vector(double x1, double y1, double x2, double y2)
        {
            _x = x1 - x2;
            _y = y1 - y2;
        }

        /// <summary>
        /// AngleBetween - the angle between 2 vectors
        /// </summary>
        /// <returns>
        /// Returns the the angle in degrees between vector1 and vector2
        /// </returns>
        /// <param name="vector1"> The first Vector </param>
        /// <param name="vector2"> The second Vector </param>
        public static double AngleBetween(Vector vector1, Vector vector2)
        {
            double sin = vector1._x * vector2._y - vector2._x * vector1._y;
            double cos = vector1._x * vector2._x + vector1._y * vector2._y;

            return Math.Atan2(sin, cos) * (180 / Math.PI);
        }
    }
}
