﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Globalization;

namespace Funkcja_kwadratowa
{
    public partial class Form1 : Form
    {
        #region zdefiniowanie zmiennych globalnych
       double xw, yw, delta, a, b, c, x1, x2;

        int jednostka;
        #endregion
        public Form1()
        {
            InitializeComponent();
            //ewentualne migotanie -wyłącz
            SetStyle(ControlStyles.UserPaint, true);
            SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            SetStyle(ControlStyles.DoubleBuffer, true);
            jednostka = 20;
          
        }

        double polozeniex(double x)

          {
            double t1;
            if (x < 0)
            {
                t1 = (20 - Math.Abs(x)) * jednostka;
                return t1;
            }
            else
            {
                t1 = (400 + x * jednostka);
                return t1;
            }

        }

        double polozeniey(double y)
        {
            double w1;
            if (y < 0)
            {
                w1 = 400 + Math.Abs(y) * jednostka;
                return w1;
            }
            else
            {
                w1 = (20 - y) * jednostka;
                return w1;
            }
        }

       void miejsca_zerowe (double x1,double x2)
        {
            double p1, t1, w1, p2, t2, w2;
            Graphics g = this.panel1.CreateGraphics();

            if (x1 == x2)
            {
                p1 = a * x1 * x1 + b * x1 + c;
                punkt z = new punkt(x1, p1);
                t1 = polozeniex(x1);
                w1 = polozeniey(p1);
                g.DrawString(z.ToString(), new Font("Arial", 7), Brushes.Green, (float)t1, (float)w1);
            }
            else
            {
                p1 = a * x1 * x1 + b * x1 + c;
                p2 = a * x2 * x2 + b * x2 + c;
                punkt z1 = new punkt(x1, p1);
                punkt z2 = new punkt(x2, p2);
                t1 = polozeniex(x1);
                t2 = polozeniex(x2);
                w1 = polozeniey(p1);
                w2 = polozeniey(p2);
                g.DrawString(z1.ToString(), new Font("Arial", 7), Brushes.Green, (float)t1, (float)w1);
                g.DrawString(z2.ToString(), new Font("Arial", 7), Brushes.Green, (float)t2, (float)w2);
            }
        }

        void wykres(double a, double b, double c, double xw, double yw)
        {
            #region zdefiniowanie zmiennych
            Graphics g=this.panel1.CreateGraphics();
            Pen p = new Pen(Color.Red);
            Pen pp = new Pen(Color.Black);
            Refresh();
            #endregion
            //rysujemy osie
            #region narysowwanie układu wspołrzędnych
            //wyznaczam końce linii (x1,y1) i (x2,y2), które zostaną połączone
            g.DrawLine(pp, panel1.Width / 2, panel1.Height, panel1.Width / 2, 0);
            g.DrawLine(pp, 0, panel1.Height / 2, panel1.Width, panel1.Height / 2);

            //rysujemy strzałki
            g.DrawLine(pp, panel1.Width / 2, 0, panel1.Width / 2 - 10, 20);
            g.DrawLine(pp, panel1.Width / 2, 0, panel1.Width / 2 + 10, 20);

            g.DrawLine(pp, panel1.Width, panel1.Height / 2, panel1.Width - 20, panel1.Height / 2 - 10);
            g.DrawLine(pp, panel1.Width, panel1.Height / 2, panel1.Width - 20, panel1.Height / 2 + 10);

            //rysujemy podziałkę - rozwiązanie dopuszczalne, gdyż rozmiar panelu jest liczbą podzielną przez jednostkę

            for (int i = 0; i < panel1.Width - 20; i += jednostka)
            {
                g.DrawLine(pp, i, panel1.Height / 2 + 3, i, panel1.Height / 2 - 3);
            }
            for (int i = 20; i < panel1.Height; i += jednostka)
            {
                g.DrawLine(Pens.Black, panel1.Width / 2 + 3, i, panel1.Width / 2 - 3, i);
            }
            //podpisujemy osie

            g.DrawString("y", new Font("Arial", 10), Brushes.Black, panel1.Width / 2 + 5, 15);
            g.DrawString("x", new Font("Arial", 10), Brushes.Black, panel1.Width - 30, panel1.Height / 2 - 20);
            g.DrawString("0", new Font("Arial", 8), Brushes.Black, panel1.Width / 2, panel1.Height / 2-15);
            g.DrawString("1", new Font("Arial", 8), Brushes.Black, panel1.Width / 2 + 5, panel1.Height / 2 - 30);
            g.DrawString("1", new Font("Arial", 8), Brushes.Black, panel1.Width / 2 + 15, panel1.Height / 2 - 20);
            #endregion

            double p1, p2, t1,t2,w1,w2;
            //sprawdzamy, czy wierzchołek funkcji lezy w ramach naszego panelu
            if (xw > 18 || xw < -18 || yw < -18 || yw > 18)
            {
                label6.Text = "Wierzchołek funkcji poza panelem.";
            }
            else
            {
                #region zaznaczenie miejsc zerowych na wykresie   
                //if (x1 == x2)
                //{
                //    p1 = a * x1 * x1 + b * x1 + c;
                //    punkt z = new punkt(x1, p1);
                //    t1 = polozeniex(x1);
                //    w1 = polozeniey(p1);
                //    g.DrawString(z.ToString(), new Font("Arial", 7), Brushes.Green, (float)t1, (float)w1);
                //}
                //else
                //{
                //    p1 = a * x1 * x1 + b * x1 + c;
                //    p2 = a * x2 * x2 + b * x2 + c;
                //    punkt z1 = new punkt(x1, p1);
                //    punkt z2 = new punkt(x2, p2);
                //    t1 = polozeniex(x1);
                //    t2 = polozeniex(x2);
                //    w1 = polozeniey(p1);
                //    w2 = polozeniey(p2);
                //    g.DrawString(z1.ToString(), new Font("Arial", 7), Brushes.Green, (float)t1, (float)w1);
                //    g.DrawString(z2.ToString(), new Font("Arial", 7), Brushes.Green, (float)t2, (float)w2);
                //}
                #endregion
                #region pętla for wyrująca wykres 
                for (double i = -20; i <= 19; i += 0.1)
                {
                    //wyliczamy punkty, które chcemy łączyć

                    p1 = a * i * i + b * i + c;
                    p2 = a * (i + 0.1) * (i + 0.1) + b * (i + 0.1) + c;

                    t1 = polozeniex(i);
                    t2 = polozeniex(i + 0.1);
                    w1 = polozeniey(p1);
                    w2 = polozeniey(p2);

                    g.DrawLine(p, (float)t1, (float)w1, (float)t2, (float)w2);
                }
                #endregion
            }
        }
             
       public void button1_Click(object sender, EventArgs e)

        {
            label6.Text = "";
            Refresh();
            #region obsługa błędu nieprawidłowej wartości
            try
            {
                a = double.Parse(textBox1.Text);
                b = double.Parse(textBox2.Text);
                c = double.Parse(textBox3.Text);
            }
            catch (Exception exc)
            {
                throw new Exception("Błędnie wprowadzona wartość!");
            }
            #endregion
            #region obliczenia
            delta = b * b - 4 * a * c;
            xw = -b / 2 * a;
            yw = -delta / 4 * a;
            #endregion
            #region wyliczenie pierwiastków i wywołanie metody rysującej wykres
            if (a == 0)
            {
                label6.ForeColor = Color.Red;
                label6.Text = "Wartość a musi być różna od zera!";
                Refresh();
            }

            else
            {
                label6.Text = "";
                if (delta < 0)
                {

                    label4.Text = "Brak pierwiastków rzeczywistych";
                    label5.Text = "";
                    label7.Text = "xw = " + Math.Round(xw, 2).ToString();
                    label8.Text = "yw = " + Math.Round(yw, 2).ToString();
                    wykres(a, b, c, xw, yw);
                 

                }

                else
                {
                    if (delta > 0)
                    {
                        x1 = (-b + Math.Sqrt(delta)) / (2 * a);
                        x2 = (-b - Math.Sqrt(delta)) / (2 * a);


                        label4.Text = "Miejsca zerowe:" ;
                        label5.Text = Math.Round(x2, 2).ToString()+" oraz " + Math.Round(x1, 2).ToString();
                        punkt z = new punkt(xw, yw);
                        label7.Text = "Współrzędne wierzchołka: ";
                        label8.Text = z.ToString();
                        wykres(a, b, c, xw, yw);
                        miejsca_zerowe(x1, x2);
                    }
                    else
                    {
                        x1 = -b / (2 * a);
                        x2 = x1;

                        label4.Text = "Miejsce zerowe:";
                        label5.Text = Math.Round(x2, 2).ToString();
                        punkt z = new punkt(xw, yw);
                        label7.Text = "Współrzędne wierzchołka: ";
                        label8.Text = z.ToString();
                        wykres(a, b, c, xw, yw);
                        miejsca_zerowe(x1, x2);
                    }
                }
            }
            #endregion
        }
    }
}
