﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using AsystentZakupów.Model;

namespace TestyJednostkoweSumatora
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestMetodyDodajKwotę()
        {
            //Arrange
            Sumator sumator = new Sumator(50, 200);

            //Act
            sumator.DodajKwotę(75);

            //Assert
            Assert.AreEqual(50 + 75, sumator.Suma);            
        }

        private Random r = new Random();

        [TestMethod]
        [Ignore]
        public void TestMetodyDodajKwotęRandom()
        {
            for (long i = 0; i < 100000000; i++)
            {
                //Arrange
                Sumator sumator = new Sumator(50, 200);

                //Act
                int kwota = r.Next(150);
                sumator.DodajKwotę(kwota);

                //Assert
                Assert.AreEqual(50 + kwota, sumator.Suma);
            }
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            Sumator sumator = new Sumator(50, 100);
            Assert.AreEqual(50, sumator.Suma);
        }

        [TestMethod]
        public void PrawdziwyTestKonstruktora()
        {
            Sumator sumator = new Sumator(50M, 100M);
            PrivateObject po = new PrivateObject(sumator);
            Assert.AreEqual(50M, po.GetField("suma"), "test pola suma");
            Assert.AreEqual(100M, po.GetField("limit"), "test pola limit");
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentOutOfRangeException))]
        public void TestKonstruktoraWyjątek()
        {
            Sumator sumator = new Sumator(500, 100);            
        }

        //suma > limit
    }
}
