﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AsystentZakupów.Model
{
    public class Sumator
    {
        private decimal limit;

        public Sumator(decimal sumaPoczątkowa, decimal limit)
        {
            Suma = sumaPoczątkowa;
            this.limit = limit;
        }

        public bool CzyKwotaPoprawna(decimal kwota)
        {
            return kwota > 0 && !(Suma + kwota > limit);
        }

        public void DodajKwotę(decimal kwota)
        {
            if (!CzyKwotaPoprawna(kwota))
                throw new ArgumentOutOfRangeException(nameof(kwota));
            Suma += kwota;
        }

        public decimal Suma { get; private set; }
    }
}
