﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using AsystentZakupów.Model;

namespace AsystentZakupów.ModelWidoku
{
    class DodajKwotę : ICommand
    {
        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public Sumator model;

        public DodajKwotę(Sumator model)
        {
            this.model = model;
        }

        public bool CanExecute(object parameter)
        {
            if (parameter == null) return false;
            decimal kwota = (decimal)parameter;
            return model.CzyKwotaPoprawna(kwota);
        }

        public void Execute(object parameter)
        {
            decimal kwota = (decimal)parameter;
            model.DodajKwotę(kwota);
        }
    }

    public class MvvmCommand : ICommand
    {
        private Action<object> execute;
        private Func<object, bool> canExecute;

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public MvvmCommand(Action<object> execute, Func<object,bool> canExecute = null)
        {
            if (execute == null) throw new ArgumentNullException(nameof(execute));
            else this.execute = execute;
            this.canExecute = canExecute;
        }

        public bool CanExecute(object parameter)
        {
            if (canExecute == null) return true;
            else return canExecute(parameter);
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
}
