﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using AsystentZakupów.Model;
using System.Windows.Input;
using System.ComponentModel;

namespace AsystentZakupów.ModelWidoku
{
    public class SumatorVM : INotifyPropertyChanged
    {
        Sumator model = new Sumator(0, 1000);

        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        private ICommand dodajKwotęCommand = null;        

        public ICommand DodajKwotę
        {
            get
            {
                if (dodajKwotęCommand == null)
                    dodajKwotęCommand = new MvvmCommand(
                        (object parameter) =>
                        {
                            decimal kwota = (decimal)parameter;
                            model.DodajKwotę(kwota);
                            OnPropertyChanged(nameof(Suma));
                        },
                        (object parameter) =>
                        {
                            if (parameter == null) return false;
                            decimal kwota = (decimal)parameter;
                            return model.CzyKwotaPoprawna(kwota);
                        });
                return dodajKwotęCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }
    }
}
