﻿using System;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Windows.Input;

using System.Windows; //olaboga!!!!!!!

namespace Zadania.ViewModel
{
    using PSPiZK;
    
    public class Zadania
    {
        private string ścieżkaPlikuXML = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPlikuXML))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXML);
            else model = new Model.Zadania();

            /*
            //testy
            model.DodajZadanie(
                new Model.Zadanie(
                    "Pierwszy",
                    DateTime.Now, DateTime.Now.AddDays(1),
                    Model.PriorytetZadania.Ważne, false));
            model.DodajZadanie(
                new Model.Zadanie(
                    "Drugie",
                    DateTime.Now, DateTime.Now.AddDays(3),
                    Model.PriorytetZadania.Krytyczne, false));
            model.DodajZadanie(
                new Model.Zadanie(
                    "Trzecie",
                    DateTime.Now, DateTime.Now.AddDays(3),
                    Model.PriorytetZadania.MniejWażne, false));
            Model.PlikXML.Zapisz(ścieżkaPlikuXML, model);
            */

            kopiujZadaniaZModelu();

            /*
            //test
            ListaZadań.Add(new Zadanie("Czwarte", DateTime.Now, DateTime.Now.AddYears(1), Model.PriorytetZadania.Ważne, false));
            */
        }

        private void kopiujZadaniaZModelu() //synchronizacja M->VM
        {
            ListaZadań.CollectionChanged -= synchronizacjaModelu;
            ListaZadań.Clear();
            foreach(Model.Zadanie zadanie in model)
            {
                ListaZadań.Add(new Zadanie(zadanie));
            }
            ListaZadań.CollectionChanged += synchronizacjaModelu;
        }

        private void synchronizacjaModelu(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch(e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = (Zadanie)e.NewItems[0]; //dodaje tylko jeden
                    if (noweZadanie != null) model.DodajZadanie(noweZadanie.PobierzModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = (Zadanie)e.OldItems[0];
                    if (usuwaneZadanie != null) model.UsuńZadanie(usuwaneZadanie.PobierzModel());
                    break;
            }
        }

        private ICommand zapiszCommand;

        public ICommand ZapiszCommand
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new MvvmCommand(
                        argument =>
                        {
                            System.IO.File.Copy(ścieżkaPlikuXML, ścieżkaPlikuXML + ".bak", true);
                            Model.PlikXML.Zapisz(ścieżkaPlikuXML, model);
                        });
                return zapiszCommand;
            }
        }

        private ICommand usuńZadanie;

        public ICommand UsuńZadanie
        {
            get
            {
                if (usuńZadanie == null)
                    usuńZadanie = new MvvmCommand(
                        o =>
                        {
                            int indeksZadania = (int)o;
                            if (indeksZadania < 0) return;
                            Zadanie zadanie = ListaZadań[indeksZadania];
                            if(!zadanie.CzyZrealizowane)
                            {
                                MessageBoxResult mbr = MessageBox.Show(
                                    "Czy jesteś pewien?",
                                    "Zadania WPF",
                                    MessageBoxButton.YesNo,
                                    MessageBoxImage.Question, MessageBoxResult.No);
                                if (mbr == MessageBoxResult.No) return;
                            }
                            ListaZadań.Remove(zadanie);
                        },
                        o =>
                        {
                            if (o == null) return false;
                            int indeksZadania = (int)o;
                            return indeksZadania >= 0;
                        });
                return usuńZadanie;
            }
        }

        private ICommand dodajZadanie;

        public ICommand DodajZadanie
        {
            get
            {
                if (dodajZadanie == null)
                    dodajZadanie = new MvvmCommand(
                        o =>
                        {
                            Zadanie zadanie = o as Zadanie;
                            if (zadanie != null) ListaZadań.Add(zadanie);
                        },
                        o =>
                        {
                            return (o as Zadanie) != null;
                        });
                return dodajZadanie;
            }
        }
    }
}
